<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvLoyaltyPointsInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvLoyaltyPoints.Point',
		'EvLoyaltyPoints.PointValue',
		'EvNavigation.Menu'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Loyalty Points',
					'pattern' => '/^\/admin\/ev_loyalty_points\//',
					'plugin' => 'EvLoyaltyPoints',
					'controller' => 'ev_loyalty_points.points',
					'model' => 'Point',
					'action' => 'index',
					'class' => 'icon-shopping-cart',
					'is_active' => 1
				)
			)
		);
		$parentId = $this->Menu->getInsertID();

		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => $parentId,
					'name' => 'Manage Loyalty Point Values',
					'pattern' => '/^\/admin\/ev_loyalty_points\/point_values\//',
					'plugin' => 'EvLoyaltyPoints',
					'controller' => 'ev_loyalty_points.point_values',
					'model' => 'PointValue',
					'action' => 'index',
					'class' => 'icon-shopping-cart',
					'is_active' => 1
				)
			)
		);
	}
}
