jQuery(document).ready(function($) {

	initMap();

	function initMap() {

		var map_canvas = $('#ev-location__map', '.ev-location');
		var latitude = $('#ev-location__map', '.ev-location').attr('data-lat');
		var longitude = $('#ev-location__map', '.ev-location').attr('data-long');
		var title = $('#ev-location__map', '.ev-location').attr('data-title');
		var zoom = $('#ev-location__map', '.ev-location').attr('data-zoom');

		var myLatlng = new google.maps.LatLng(parseFloat(latitude), parseFloat(longitude));

		var mapOptions = {
			center: myLatlng,
			zoom: parseInt(zoom),
			scrollwheel: false
		};

		var map = new google.maps.Map(
		    document.getElementById('ev-location__map'),
		    mapOptions
		);

		if (typeof customMarker != 'undefined' && Object.keys(customMarker).length > 0) {
			// build custom map icon, when supplied
			var image = {
				url: customMarker.image,
				// This marker is 20 pixels wide by 32 pixels tall.
				size: new google.maps.Size(
					parseInt(customMarker.width),
					parseInt(customMarker.height)
				),
				// The origin for this image is 0,0.
				origin: new google.maps.Point(0,0),
				// The anchor for this image is the base of the flagpole at 0,32.
				anchor: new google.maps.Point(
					(parseInt(customMarker.width)/2),
					parseInt(customMarker.height)
				)
			};
		} else {
			if (typeof customerMarker != 'undefined' && customerMarker != '') {
				var image = customerMarker;
			} else {
				// set default icon as a fallback
				var image = '//maps.google.com/mapfiles/marker.png';
			}
		}

		var marker = new google.maps.Marker({
			position: myLatlng,
			map: map,
			title: title,
			icon: image
		});
	}

});
