<?php
	$fields = Configure::read('EvLocation.fields');
?>
<div class="ev-location">

	<div class="row">
		<div class="col-md-6">
			<h1><?php echo $data['Location']['name']; ?></h1>


			<?php
				if (
					in_array('location', $fields)
					&& isset($data['Location']['location'])
					&& !empty($data['Location']['location'])
				) {
					echo '<h2>' . $data['Location']['location'] . '</h2>';
				}

				if (
					in_array('body', $fields)
					&& isset($data['Location']['body'])
					&& !empty($data['Location']['body'])
				) {
					echo $data['Location']['body'];
				}

				if (
					in_array('website', $fields)
					&& isset($data['Location']['website'])
					&& !empty($data['Location']['website'])
				) {
					echo '<p>' . $this->Html->link(
						'Visit ' . $data['Location']['name'] . '\'s website',
						$data['Location']['website']
					) . '</p>';
				}

				if (
					in_array('address', $fields)
					&& isset($data['Location']['address'])
					&& !empty($data['Location']['address'])
				) {
					echo $data['Location']['address'];
				}

				echo '<dl>';

					if (
						in_array('email', $fields)
						&& isset($data['Location']['email'])
						&& !empty($data['Location']['email'])
					) {
						echo '<dt>Email</dt>';
						echo '<dd>' . $data['Location']['email'] . '</dd>';
					}

					if (
						in_array('telephone', $fields)
						&& isset($data['Location']['telephone'])
						&& !empty($data['Location']['telephone'])
					) {
						echo '<dt>Telephone</dt>';
						echo '<dd>' . $data['Location']['telephone'] . '</dd>';
					}

					if (
						in_array('telephone_alt', $fields)
						&& isset($data['Location']['telephone_alt'])
						&& !empty($data['Location']['telephone_alt'])
					) {
						echo '<dt>Alt. Telephone</dt>';
						echo '<dd>' . $data['Location']['telephone_alt'] . '</dd>';
					}

					if (
						in_array('fax', $fields)
						&& isset($data['Location']['fax'])
						&& !empty($data['Location']['fax'])
					) {
						echo '<dt>Fax</dt>';
						echo '<dd>' . $data['Location']['fax'] . '</dd>';
					}

				echo '</dl>';
			?>
		</div>
		<div class="col-md-6">
			<?php
				if (isset($data['Image'][0]) && !empty($data['Image'][0])):
					echo $this->Image->resize($data['Image'][0], array(
						'alt' => $data['Image'][0]['alt'],
						'class' => 'img-responsive',
						'width' => 555
					));
				endif;
			?>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12">
			<?php
				// load default values from config
				$map = Configure::read('EvLocation.map');

				if (
					isset($data['Location']['longitude'])
					&& !empty($data['Location']['longitude'])
				) {
					$map['longitude'] = $data['Location']['longitude'];
				}

				if (
					isset($data['Location']['latitude'])
					&& !empty($data['Location']['latitude'])
				) {
					$map['latitude'] = $data['Location']['latitude'];
				}
			?>
			<div class="ev-location__map_container">
				<div
					id="ev-location__map"
					class="ev-location__map_container__map"
					data-long="<?php echo $map['longitude']; ?>"
					data-lat="<?php echo $map['latitude']; ?>"
					data-title="<?php echo $data['Location']['name']; ?>"
					data-zoom="<?php echo $map['zoom']; ?>"
				></div>
			</div>
		</div>
	</div>

</div>

<?php

	// load css
	echo $this->Html->css(array(
		'EvLocation.ev-location'
	), array('inline' => false));

	// if set, assign custom marker
	$customMarker = Configure::read('EvLocation.marker');
	if (is_array($customMarker)) {
		echo $this->Html->scriptBlock('var customMarker = {
			image: \'' . addslashes($customMarker['image']) . '\',
			height: ' . $customMarker['height'] . ',
			width: ' . $customMarker['width'] . '
		};');
	} else {
		echo $this->Html->scriptBlock('var customMarker = \'' . $customMarker . '\';');
	}

	// load javascript
	echo $this->Html->script(array(
		'//maps.googleapis.com/maps/api/js?v=3.1',
		'EvLocation.jquery.main'
	), array('inline' => false));

?>