EvLocation Plugin
================

Authors: Stewart Doxey (@MrStu84), Rick Mills


Changelog
----------------
**2.1.1.0**

Changed the database structure to use a singe field for map data (map_data). This works with the updated way we do maps to resolve issues in the SiteSettings plugin.

This does not affect existing views as an afterFind method converts the map_data json back to an array for display, however this will obviously affect old sites using this plugin.


Introduction
----------------

A simple composer plugin for adding locations to a CakePHP site.


Installation
----------------

To install, run the following command in the www/app directory with composer:-

	composer require evoluted/location

To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

	Console/cake Migrations.migration run all --plugin EvLocation

Add the following to the plugin load array in 'app/Config/bootstrap.php':-

	'EvLocation' => array(
		'bootstrap' => true,
		'routes' => true
	)

You will want to add an item to the admin menu for managing locations:-

* /admin/ev_location/locations/

To setup/override the plugin's default config create a new config file 'app/Config/Plugin/ev_location.php'.

The following options are available:-

* fields				- specify which form fields are to show in the admin and also used
						  throughout the app, if no fields are defined then all will be
						  available in the admin

* google_maps_client_id	- assign the google maps client id related to the wesbite. This can
						  generated here, https://code.google.com/apis/console/?noredirect
						  ** This field is required **

* map 					- an array built up of default longitude, latitude and zoom values
						  ** This field is required **

* marker				- can be supplied as an array (with image, width and height parameters),
						  or as a string containing the custom map icon image path. If nothing
						  is supplied then the icon will fallback to the Google default

* pageId 				- specify the page id used to show content on the locations
						  index / multipoint template

* type 					- 'listing' / define whether the index page should show a listing of available locations, which then click through to individual location pages
						  'inject' / uses a component to call the requested location data available into a controller method. e.g. when placing location data on a contact us page
						  'multipoint' / that shows one make on the locations page containing multiple points (one per location) on the same map

						  ** Please note: the multipoint functionality is current awaiting construction, thanks for volunteering!




Using EvLocation
----------------

EvLocation works straight out of the box. Basic templates can be found in the View directory and are intended for demo purposes only.

To use in 'inject' mode, add 'EvLocation.Locations' to the controllers components array and call '$this->Locations->readForTemplate($id)' from the required method, passing in the id of the location to be retrieved.


Extending Plugin
----------------

Don't be bloody lazy, and do things properly. Please don't edit the plugin directly but override it from within your own app.

For example,
* you can override the view templates by creating new views in '/app/View/Plugin/EvLocation/'
* you can override the location controller by creating '/app/Controller/EvLocationLocationsController.php', and extending accordingly