<?php

App::uses('EvLocationAppModel', 'EvLocation.Model');

class Location extends EvLocationAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'config' => 'EvLocation'
		),
		'MetaData.Meta',
		'Tree'
	);

	public $imageSlots = -1;

	public $order = array(
		'Location.lft' => 'ASC'
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required field'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters long'
			)
		),
	);

/**
 * Get all locations.
 *
 * @param array $params Custom query parameters.
 * @return array.
 */
	public function all($params = []) {
		$defaultParams = [
			'conditions' => [
				$this->alias . '.is_active' => true,
			],
			'contain' => [
				'Image',
			],
		];

		$params = $this->mergeQueryParams($defaultParams, $params);

		return $this->find('all', $params);
	}

	/**
	 * AfterFind
	 *
	 * We're using this to decode the map data and add the lat and long details into the result.
	 *
	 * @param  array  $results  DB Results
	 * @param  boolean  $primary
	 * @return  array  DB Resuts
	 */
	public function afterFind($results, $primary = false) {

		if (! empty($results)) {

			foreach ($results as $row => $result) {

				if (! empty($result['Location']['map_data'])) {

					$map_data = json_decode($result['Location']['map_data'],true);

					foreach ($map_data as $key => $value) {

						$results[$row]['Location'][$key] = $value;

					}

				}

			}

		}

		return $results;

	}

}
