<?php

App::uses('EvLocationAppController', 'EvLocation.Controller');

class LocationsController extends EvLocationAppController {


	public function beforeFilter() {

		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view',
			'multipoint'
		));

	}

	protected function _adminFormFields() {

		// Model instance
		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		// remove all fields related to the Location model that are
		// not defined in the plugin config file
		$requestedFields = Configure::read('EvLocation.fields');

		if (empty($requestedFields)) {
			$requestedFields = array();
		}

		// assign default fields
		$requestedFields = array_merge($requestedFields, array(
			'id',
			'name',
			'map_data',
			'created',
			'modified',
			'is_active'
		));

		if (isset($requestedFields) && !empty($requestedFields)) {
			foreach ($fields as $key => $value) {
				if (
					preg_match("/{$Model->alias}/", $key)
					&& !in_array(str_replace("{$Model->alias}.", '', $key), $requestedFields)
				) {
					unset($fields[$key]);
				}
			}
			// unset routable fields when type equals inject
			$type = Configure::read('EvLocation.type');
			if (isset($type) && $type == 'inject') {
				unset($fields['Route.id']);
				unset($fields['Route.alias']);
			}
		}

		return $fields;
	}


	protected function _adminFormToolbar($id = null) {

		// return empty array when type equals inject
		$type = Configure::read('EvLocation.type');
		if (isset($type) && $type == 'inject') {
			return null;
		} else {
			return parent::_adminFormToolbar($id);
		}

	}


	protected function _adminFormMetaFields() {

		// unset meta data fields when type equals inject
		$type = Configure::read('EvLocation.type');
		if (isset($type) && $type == 'inject') {
			return array();
		} else {
			return parent::_adminFormMetaFields();
		}

	}


	public function admin_index() {

		// return admin_edit, if in inject mode
		$type = Configure::read('EvLocation.type');
		if (isset($type) && $type == 'inject') {

			$Model = $this->{$this->modelClass};
			$modelAlias = $Model->alias;

			$this->Session->write("Admin.$modelAlias.return", true);

			$id = $Model->field('id', array('id IS NOT NULL'), 'created DESC');
			if (empty($id)) {
				$id = null;
			}

			return $this->admin_edit($id);
		} else {

			return parent::admin_index();
		}

	}


	public function admin_edit($id = null) {

		$Model = $this->{$this->modelClass};

		// override imageSlots when type equals inject
		$type = Configure::read('EvLocation.type');
		if (isset($type) && $type == 'inject') {
			$Model->imageSlots = 0;
		}

		return parent::admin_edit($id);
	}


/**
 * Returns locations listing, based on type defined in config.
 *
 * @return void.
 */
	public function index() {
		$Model = $this->{$this->modelClass};

		$pageId = Configure::read('EvLocation.pageId');
		if (!empty($pageId)) {
			$this->assignPage($pageId, 'page');
		}

		$params = [
			'contain' => [
				'Image',
			],
		];

		$this->set('listing', $Model->all($params));

		$viewType = Configure::read('EvLocation.type');

		if (isset($viewType) && $viewType == 'multipoint') {

			$this->view = 'EvLocation.Locations/multipoint';
		} else {

			$this->view = 'EvLocation.Locations/index';
		}
	}

/**
 * View
 *
 * Returns the requested location
 */
	public function view($id = null) {

		// Model instance
		$Model = $this->{$this->modelClass};

		// find and assign listing of location
		$params = array(
			'conditions' => array(
				'Location.is_active' => true,
			),
			'contain' => array(
				'Image'
			),
		);

		// determine whether we are showing a specific location
		if ($id) {
			$params['conditions']['Location.id'] = $id;
		} else {
			$params['order']['Location.lft'] = 'asc';
		}

		$data = $Model->readForView($id, $params);

		if (!isset($data) || empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);

		// assign page meta data
		$this->Meta->set($data);

		$this->view = 'EvLocation.Locations/view';
	}
}
