<?php
class ImprovementsToMapDataStorageAndGeneration extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'improvements_to_map_data_storage_and_generation';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_location_locations' => array(
					'map_data' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8', 'after' => 'website'),
				),
			),
			'drop_field' => array(
				'ev_location_locations' => array('longitude', 'latitude', 'google_address'),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_location_locations' => array('map_data'),
			),
			'create_field' => array(
				'ev_location_locations' => array(
					'longitude' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'latitude' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'google_address' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 254, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
