<?php

App::uses('AppShell', 'Console/Command');

App::uses('JupixSync', 'EvJupix.Lib');

class JupixSyncShell extends AppShell {

	public function createSyncJob() {
		return false;
	}

/**
 * Synchronise properties from a Jupix feed using the file settings set in the config.
 * @return boolean Whether any properties were successfully synced
 */
	public function syncProperties() {
		$this->out('Synchronising Jupix properties');

		CakeLog::write('jupixSync', "\n \n Syncing Properties on: " . date("Y-m-d H:i:s") . "\n \n");

		$synced = JupixSync::syncProperties(
			Configure::read('EvJupix.' . Configure::read('EvJupix.syncFileFrom')),
			(Configure::read('EvJupix.syncFileFrom') == 'localFile' ? false : true)
		);

		if ($synced) {
			$this->out('Properties were synced successfully');
		} else {
			$this->out('Either no properties were found or there was an issue saving some properties');
		}

		return $synced;
	}

/**
 * Properties get their service_last_modified fields set back to the epoch and then a Jupix sync is run.
 * This makes sure that all properties are synchronised with the current data in the feed.
 * @return bool Whether the property sync was successful or not
 */
	public function resetProperties() {
		$this->out('Resetting Jupix properties');
		$updated = JupixSync::resetProperties();

		if ($updated) {
			$this->out('Properties were reset successfully');

			$synced = $this->syncProperties();
		} else {
			$this->out('Properties failed to reset');

			$synced = false;
		}

		return $synced;
	}
}
