<?php

App::uses('AppHelper', 'View/Helper');

App::uses('InventoryLib', 'EvInventory.Lib');

class InventoryHelper extends AppHelper {

/**
 * Show item based on stock level and options.
 *
 * @param array $item Item array containing subarray of Inventory data.
 * @return bool True if the item can be purchased, false otherwise.
 */
	public function allowPurchase($item) {
		return InventoryLib::allowPurchase($item);
	}

/**
 * Check if we need to show the delayed message.
 *
 * @param array $item Item array containing subarray of Inventory data.
 * @return bool True if the delayed message should be shown, false otherwise.
 */
	public function showDelayedMessage($item) {
		return InventoryLib::showDelayedMessage($item);
	}

/**
 * Check to see if it has low stock
 *
 * @param array $item Item array containing subarray of Inventory data.
 * @return bool True if the low stock message should be shown, false otherwise.
 */
	public function showLowStockMessage($item) {
		return InventoryLib::showLowStockMessage($item);
	}

/**
 * Show out of stock message
 *
 * @return string
 */
	public function oosMessage() {
		return Configure::read('EvInventory.oosMessage');
	}

/**
 * Show the delayed message
 *
 * @return string
 */
	public function delayedMessage() {
		return Configure::read('EvInventory.delayedMessage');
	}

/**
 * Show the low stock level message
 *
 * @return string
 */
	public function lowStockMessage() {
		return Configure::read('EvInventory.lowStockMessage');
	}
}
