<?php

App::uses('EvInventoryAppModel', 'EvInventory.Model');

class TestModel extends EvInventoryAppModel {
}

class InventoriesBehaviorTest extends CakeTestCase {

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
	'plugin.ev_inventory.inventory'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();

		$this->Model = EvClassRegistry::init('TestModel');
		$this->Model->addBehavior('EvInventory.Inventories');

		$this->Inventory = EvClassRegistry::init('EvInventory.Inventory');
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();

		unset($this->Model);
	}

	public function testReduceStockReducesTheCorrectStockLevel() {
		$this->assertTrue(
			$this->Model->reduceStock(1, 1)
		);

		$data = $this->Inventory->find(
			'first',
			array(
				'conditions' => array(
					'Inventory.id' => 1
				)
			)
		);

		$this->assertEquals(
			9,
			$data['Inventory']['stock']
		);
	}
}
