<?php

class InventoryActions {

	/**
	 * the inventory row we're delaing with
	 */
	public $inventory = false;

	/**
	 * the type of actions (warning / out of stock)
	 *
	 */
	public $type = false;

	/**
	 * construct
	 *
	 * @param 	array 	$inventory 	The invetory row
	 */
	public function __construct($inventory, $type) {
		$this->inventory = $inventory;
		$this->type = $type;
	}

	/**
	 * email the site admin
	 *
	 */
	public function email() {
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');

		if ($this->type == 'outofstock') {
			$template = 'out-of-stock';
			$subject = __('An item is now out of stock');

		} else {
			$template = 'warning-stock';
			$subject = __('An item has reached it\'s low stock warning level');
		}

		$itemName = $this->_getItemName(
			$this->inventory,
			Configure::read('EvInventory.InventoryNamePath')
		);

		$itemUrl = $this->_getItemUrl(
			$this->inventory,
			Configure::read('EvInventory.InventoryUrlArray')
		);

		//Check if we have the item name and url, if not then don't send the email
		if ($itemName == 'Unknown' || empty($itemUrl)) {
			return false;
		}

		// queue the email for the admin
		$QueuedTask->createJob(
			'CustomEmail',
			array(
				'from' => array(
					Configure::read('SiteSetting.general.admin_email') => Configure::read('SiteSetting.general.site_title')
				),
				'to' => array(
					Configure::read('SiteSetting.general.admin_email')
				),
				'subject' => $subject,
				'viewVars' => array(
					'itemName' => $itemName,
					'itemUrl' => $itemUrl,
				),
				'helpers' => array(
					'Html'
				),
				'template' => 'EvInventory.' . $template
			)
		);
	}

	/**
	 * get the item name given the array of data and config
	 *
	 * @param 	string 	$inventory 		The inventory row we are wanting the name of
	 * @param 	array 	$pathConfig 	The name path Config
	 * @return 	string
	 */
	protected function _getItemName($inventory, $pathConfig) {
		// Try to find the model name
		$modelName = Hash::get($inventory, 'Inventory.model');
		if (empty($modelName)) {
			return 'Unknown';
		}

		// get the config so we know where to find the data for this row
		$config = $pathConfig;
		if (empty($config[$modelName])) {
			return 'Unknown';
		}
		// reposition array to make it easier to work
		$config = $config[$modelName];

		$separator = ' ';
		if (! empty($config['separator'])) {
			$separator = $config['separator'];
			unset($config['separator']);
		}

		if (! is_array($config)) {
			$config = array($config);
		}

		$item = array();
		foreach ($config as $path) {
			$value = Hash::get($inventory, $path);

			if (! empty($value) && array_search($value, $item) === false) {
				$item[] = $value;
			}
		}

		if (empty($item)) {
			return 'Unknown';
		}

		return implode($separator, $item);
	}

	/**
	 * get the item url given the array of data
	 *
	 * @param 	string 	$inventory 		The inventory row we are wanting the url of
	 * @param 	array 	$urlConfig 	The name path Config
	 * @return 	string
	 */
	protected function _getItemUrl($inventory, $urlConfig) {
		// Try to find the model name
		$modelName = Hash::get($inventory, 'Inventory.model');
		if (empty($modelName)) {
			return '';
		}

		// get the config so we know where to find the data for this row
		$config = $urlConfig;
		if (empty($config[$modelName])) {
			return '';
		}

		// reposition array to make it easier to work
		$route = $config[$modelName];

		// loop and check for any hash data to get
		foreach ($route as $key => $item) {
			if (is_array($item)) {
				foreach ($item as $path) {
					$data = Hash::get($inventory, $path);
					if (! empty($data)) {
						$route[] = $data;
					}
				}

				unset($route[$key]);
			}
		}

		return Router::url(
			$route,
			true
		);
	}
}
