<?php

App::uses('CakeEventListener', 'Event');

class EvInventoryReduceStockListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvInventory.Inventory.reduce' => array(
				'callable' => 'reduceStock',
				'priority' => 50
			)
		);
	}

	/**
	 * Reduce the stock levels for the given item
	 *
	 * @param 	CakeEvent
	 */
	public function reduceStock(CakeEvent $Event) {
		if (empty($Event->data['model']) || empty($Event->data['model_id']) || empty($Event->data['quantity'])) {
			return false;
		}

		$Model = EvClassRegistry::init($Event->data['model']);
		if (! is_object($Model)) {
			return false;
		}

		$Model->reduceStock($Event->data['model_id'], $Event->data['quantity']);
	}
}