<?php

App::uses('CakeEventListener', 'Event');

class EvInventoryOutOfStockLevelListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvInventory.Behavior.Inventory.saved' => array(
				'callable' => 'checkLevel',
				'priority' => 50
			)
		);
	}

	/**
	 * check the warning level
	 *
	 */
	public function checkLevel(CakeEvent $Event) {
		//This event is only fired when the stock is updated through the CMS. Check if we want to send an email
		$sendEmail = Configure::read('EvInventory.sendStockEmailsAfterCmsSave');
		if (!empty($sendEmail) && $sendEmail) {
			$modelName = EvClassRegistry::getNameFromModel($Event->subject());

			$Inventory = EvClassRegistry::init('EvInventory.Inventory');

			$itemInventory = $Inventory->getInventory($modelName, $Event->data['id']);

			if ($itemInventory['Inventory']['stock'] <= 0) {
				$Inventory->outOfStock($itemInventory);
			}
		}

		return true;
	}
}
