<?php
class AddIndexingOnTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_indexing_on_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'ev_inventory_inventories' => array(
					'model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'key' => 'index', 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
				),
			),
			'create_field' => array(
				'ev_inventory_inventories' => array(
					'indexes' => array(
						'model_model_id_stock' => array('column' => array('model', 'model_id', 'stock'), 'unique' => 0),
						'model_model_id' => array('column' => array('model', 'model_id'), 'unique' => 0),
					),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'ev_inventory_inventories' => array(
					'model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
				),
			),
			'drop_field' => array(
				'ev_inventory_inventories' => array('indexes' => array('model_model_id_stock', 'model_model_id')),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
