<?php

App::uses('InflectorExt', 'EvInflector.Lib');

class InflectorExtHelper extends AppHelper {

	/**
	 * magic method to check if the function exists in the lib file and call it if so
	 * if not, it will try and return the string we were trying to Inflect
	 * if it can't do that, it will just return false
	 *
	 */
	public function __call($name, $arguments) {
		if (method_exists('InflectorExt', $name)) {

			return call_user_func_array('InflectorExt::' . $name, $arguments);
		} else {

			// we can't find it, try and return the string
			// it should, in almost every case, be the first argument
			if (! empty($arguments) && is_array($arguments)) {

				return array_shift($arguments);
			}
		}

		return false;
	}

}