<?php

App::uses('Inflector', 'Utility');

class InflectorExt extends Inflector {

	/**
	 * Humanize a string. Differs from CakePHP default humanize in that it accepts camelCased strings
	 * rather then snake_cased.
	 *
	 * @param string $camelCasedWord Camel-cased word to be "underscorized"
	 * @return string Human-readable string
	 */
	public static function camelToHumanize($str) {
		$str = self::humanize( self::underscore($str) );
		$str = str_replace('Id', 'ID', $str);
		return $str;
	}

	/**
	 * Pluralize a string. Differs from CakePHP default Pluralize in that it accepts camelCased strings
	 * rather then snake_cased.
	 *
	 * @param string $camelCasedWord Camel-cased word to be "underscorized"
	 * @return string Word in plural
	 */
	public static function camelToPluralize($str) {
		return self::pluralize( self::camelToHumanize($str) );
	}

	/**
	 * Snake cases a string
	 * @param  string $str String to transform
	 * @return string
	 */
	public static function snake($str) {
		return strtolower(self::slug($str));
	}

	/**
	 * Slug encoding but preserve chars
	 * @param  string $str String to transform
	 * @param  string $replacement the replacement character for spaces
	 * @return string
	 */
	public static function slugPreserveChars($str, $replacement = '_') {
		$str = str_replace(' ', $replacement, $str);
		$str = strtolower($str);

		return $str;
	}

/**
 * Slug encoding to replace unsafe characters with safe alternatives
 * @param string $str String to transform
 * @param string $replacement the replacement character for spaces
 * @return string
 */
	public static function slugUrlSafePreserveChars($string = '', $toUrl = true) {
		$reservedChars = [
			'&' => '~ampersand~',
			'$' => '~dollar~',
			'+' => '~plus~',
			',' => '~comma~',
			'/' => '~slash~',
			':' => '~colon~',
			';' => '~semicolon~',
			'=' => '~equals~',
			'?' => '~questionmark~',
			'@' => '~at~',
			'#' => '~pound~'
		];

		$unsafeChars = [
			' ' => '~space~',
			'<' => '~lessthan~',
			'>' => '~greaterthan~',
			'[' => '~opensquarebracket~',
			']' => '~closequarebracket~',
			'{' => '~opencurlybracket~',
			'}' => '~closecurlybracket~',
			'|' => '~pipe~',
			'\\' => '~backslash~',
			'^' => '~caret~',
			'%' => '~percent~',
			'\'' => '~apostrophe~',
			'"' => '~quotemark~',
			'.' => '~period~'
		];

		if (! $toUrl) {
			$reservedChars = array_flip($reservedChars);
			$unsafeChars = array_flip($unsafeChars);
		}

		foreach ($reservedChars as $characterKey => $characterIndex) {
			$string = str_replace($characterKey, $characterIndex, $string);
		}

		foreach ($unsafeChars as $characterKey => $characterIndex) {
			$string = str_replace($characterKey, $characterIndex, $string);
		}

		return $string;
	}
}
