EvImpersonate
=============

Plugin to allow a user to impersonate other users.

The plugin works by temporarily storing the current user in the session as `Auth.Impersonator` and replaces `Auth.user` with the user you want to impersonate. When you end the impersonation session `Auth.user` is restored to the original value and the `Auth.Impersonator` is deleted. The plugin checks against the user's group to check for permission to impersonate before starting a session; this can be customised using the components settings.

Install
-------

If you're not using `CakePlugin::loadAll()` add the following in `app/Config/bootstrap.php`:

	CakePlugin::load('EvImpersonate');

Next you need to load the component in the controller that you want to handle impersonation through. This is most likely to be your app's `EvCoreUsersController`. You need to load the component before the `beforeFilter` callback, so use the controller's constructor:-

	public function __construct($request = null, $response = null) {
		parent::__construct($request, $response);

		$this->Impersonate = $this->Components->load(
			'EvImpersonate.Impersonate'
		);
	}

You will now need to create a couple of actions for starting and ending an impersonation session and call the components `impersonate()` and `unimpersonate()` methods:-

	public function impersonate($id) {
		// Pass the user ID that we want to impersonate.
		$this->Impersonate->impersonate($id);
	}

	public function unimpersonate() {
		$this->Impersonate->unimpersonate();
	}

It is then up to you how you link to these actions in your CMS.

*Note:* it's important that you enable the `SiteSetting.users.enable_registration` setting in the CMS if you want to be able to access these actions from the users controller.

Configuration
-------------

The plugin has been set up so that it is easy to configure for your specific needs by passing settings to the component when initialised. The following options are available:-

 * `userModel` - the user model used for the auth session (default: 'User').
 * `params` - any additional parameters for the query used to retrieve the user we want to impersonate (by default this adds a restriction on the user group).
 * `canImpersonateParams` - the query parameters for checking the current user can impersonate other users (by default this adds a restriction based on the user group).
 * `impersonateRedirect` - the route to redirect to after initiating an impersonation (default: '/')
 * `unimpersonateRedirect` - the route to redirect to after ending an impersonation session (by default this is the users admin page).

Impersonate Permissions
-----------------------

The plugin can use acl permissions instead of usergroup levels if required. To enable this functionality you need enable `useAclPermissions` in the plugin config and have had run the `EvImpersonatePermissionsShell.php`.

