<?php

App::uses('AppHelper', 'View/Helper');

App::uses('Impersonate', 'EvImpersonate.Lib');

class ImpersonateHelper extends AppHelper {

/**
 * Check if the current user is impersonating another user by checking the session data.
 *
 * @return bool.
 */
	public function isImpersonating() {
		return Impersonate::isImpersonating();
	}

/**
 * Get the current impersonator.
 *
 * @param string $path The path to get a specific field from the impersonating user.
 * @return mixed The impersonating user, or specific field if $path is provided.
 */
	public function getImpersonator($path = null) {
		return Impersonate::getImpersonator($path);
	}

/**
 * Get the current impersonated user. This would be the user currently in the auth session.
 *
 * @param string $path The path to get a specific field from the impersonated user.
 * @return mixed The impersonated user, or specific field if $path is provided.
 */
	public function getImpersonated($path = null) {
		return Impersonate::getImpersonated($path);
	}
}
