<?php

App::uses('CakeSession', 'Lib');

class Impersonate {

/**
 * Check if the current user is impersonating another user by checking the session data.
 *
 * @return bool.
 */
	static public function isImpersonating() {
		return CakeSession::check('Auth.Impersonator') === true;
	}

/**
 * Get the current impersonator.
 *
 * @param string $path The path to get a specific field from the impersonating user.
 * @return mixed The impersonating user, or specific field if $path is provided.
 */
	static public function getImpersonator($path = null) {
		$impersonator = CakeSession::read('Auth.Impersonator');

		if ($path !== null) {
			$impersonator = Hash::get($impersonator, $path);
		}

		return $impersonator;
	}

/**
 * Get the current impersonated user. This would be the user currently in the auth session.
 *
 * @param string $path The path to get a specific field from the impersonated user.
 * @return mixed The impersonated user, or specific field if $path is provided.
 */
	static public function getImpersonated($path = null) {
		$impersonated = CakeSession::read('Auth.User');

		if ($path !== null) {
			$impersonated = Hash::get($impersonated, $path);
		}

		return $impersonated;
	}

/**
 * Remove the current impersonator from the session. This is normally handled by the unimpersonate
 * method but this method can be used separately to tidy up the session data to stop the user
 * impersonating themself.
 *
 * @return bool. True if removed, otherwise false.
 */
	static public function removeImpersonator() {
		return CakeSession::delete('Auth.Impersonator');
	}
}
