<?php

App::uses('CakeEventListener', 'Event');

class EvImpersonateAuthLoginLogoutListener implements CakeEventListener {

/**
 * Returns a list of events this object is implementing. When the class is registered in an event
 * manager, each individual method will be associated with the respective event.
 *
 * @return array Associative array or event key names pointing to the function that should be called in the
 *                           object when the respective event is fired.
 */
	public function implementedEvents() {
		return array(
			'Auth.beforeLogin' => 'checkImpersonator',
			'Auth.afterLogout' => 'restoreImpersonator',
		);
	}

/**
 * Check for an impersonator when logging in.
 *
 * If the current user logging in isn't impersonating anybody then they are logged in as normal.
 *
 * If the current user logging in is impersonating somebody but is logging in as somebody else then
 * the user is logged in but continues to be impersonated.
 *
 * If the current user logging in is impersonating somebody and they are logging in to the
 * user impersonating then they are unimpersonated and logged in as normal. Essentially this stops
 * them impersonating.
 *
 * @param CakeEvent $Event The event that was fired.
 * @return void.
 */
	public function checkImpersonator(CakeEvent $Event) {
		if ($Event->subject()->_controller->Impersonate->isImpersonating()) {
			$impersonator = $Event->subject()->_controller->Impersonate->getImpersonator();
			$user = $Event->data['user'];

			if ($user['User']['id'] == $impersonator['User']['id']) {
				$Event->subject()->_controller->Impersonate->removeImpersonator();
			}
		}
	}

/**
 * Restore the impersonating user to the current user when the impersonated user has been logged out.
 *
 * @param CakeEvent $Event The event that was fired.
 * @return void.
 */
	public function restoreImpersonator(CakeEvent $Event) {
		if ($Event->subject()->_controller->Impersonate->isImpersonating()) {
			$Event->subject()->_controller->Impersonate->unimpersonate();
		}
	}
}
