<?php

App::uses('AppController', 'Controller');

class ImpersonateController extends AppController {

	public $components = [
		'EvImpersonate.Impersonate',
	];

	public $adminActions = [
		'admin_impersonate',
		'admin_unimpersonate',
	];

/**
 * Allow public access to methods via the Auth allow settings.
 *
 * @return void.
 * @see Controller::beforeFilter()
 */
	public function beforeFilter() {
		$this->Auth->allow([
			'impersonate',
			'unimpersonate',
		]);

		parent::beforeFilter();
	}

/**
 * Impersonate a user. The impersonation redirect and permission can be overridden by providing the
 * required values in the query string. If no redirect is specified then the user is redirected
 * back to the referer.
 *
 * @param int $userId The id of the user to impersonate.
 * @return void. Redirects via the impersonate component or to the referer.
 */
	public function impersonate($userId = null) {
		if (empty($userId)) {
			if (empty($this->request->data['User']['id'])) {
				$this->Flash->fail(
					[
						'title' => 'Could not impersonate',
						'description' => 'The user could not be impersonated because the user id was missing',
					]
				);
			}

			$userId = $this->request->data['User']['id'];
		}

		if (!empty($this->request->query['impersonateRedirect'])) {
			$this->Impersonate->settings['impersonateRedirect'] = $this->request->query['impersonateRedirect'];
		}

		if (!empty($this->request->query['unimpersonateRedirect'])) {
			$this->Session->write('EvImpersonate.unimpersonateRedirect', $this->request->query['unimpersonateRedirect']);
		}

		if (!empty($this->request->query['impersonatePermission'])) {
			$this->Impersonate->settings['canImpersonatePermission'] = $this->request->query['impersonatePermission'];
		}

		if (!$this->Impersonate->impersonate($userId)) {
			$this->Flash->fail(
				[
					'title' => 'Could not impersonate',
					'description' => 'The user could not be impersonated',
				]
			);
		}

		$this->redirect($this->referer());
	}

/**
 * Admin method to impersonate a user.
 *
 * @param int $userId The id of the user to impersonate.
 * @return void. Redirects.
 * @see ImpersonateController::impersonate()
 */
	public function admin_impersonate($userId = null) {
		$this->impersonate($userId);
	}

/**
 * Unimpersonate the current user. The unimpersonationg redirect can be overridden by providing the
 * redirect value in the query string. If no redirect is specified then the user is redirected back
 * to the referer.
 *
 * @return void. Redirects via the impersonate component or to the referer.
 */
	public function unimpersonate() {
		if (!empty($this->request->query['unimpersonateRedirect'])) {
			$this->Impersonate->settings['unimpersonateRedirect'] = $this->request->query['unimpersonateRedirect'];
		} elseif ($this->Session->check('EvImpersonate.unimpersonateRedirect')) {
			// Check for a session var set when impersonation began
			$this->Impersonate->settings['unimpersonateRedirect'] = $this->Session->read('EvImpersonate.unimpersonateRedirect');
			$this->Session->delete('EvImpersonate.unimpersonateRedirect');
		}

		if (!$this->Impersonate->unimpersonate()) {
			$this->Flash->fail(
				[
					'title' => 'Could not unimpersonate',
					'description' => 'The user could not be unimpersonated',
				]
			);
		}

		$this->redirect($this->referer());
	}

/**
 * Admin method to unimpersonate a user.
 *
 * @return void. Redirects.
 * @see ImpersonateController::unimpersonate()
 */
	public function admin_unimpersonate() {
		$this->unimpersonate();
	}
}
