<?php

App::uses('AppShell', 'Console/Command');

App::uses('Controller', 'Controller');
App::uses('ComponentCollection', 'Controller');
App::uses('AclComponent', 'Controller/Component');

class EvImpersonatePermissionsShell extends AppShell {

/**
 * Root node name.
 *
 * @var string
 **/
	public $rootNode = 'impersonations';

/**
 * Internal Clean Actions switch
 *
 * @var bool
 **/
	protected $_clean = false;

/**
 * Start up And load Acl Component / Aco model
 *
 * @param Controller $controller The controller to use to check for permissions.
 * @return void
 **/
	public function startup($controller = null) {
		if (!$controller) {
			$controller = new Controller(new CakeRequest());
		}
		$collection = new ComponentCollection();
		$this->Acl = new AclComponent($collection);
		$this->Acl->startup($controller);
		$this->Aco = $this->Acl->Aco;
		$this->controller = $controller;
		$this->_Permission = EvClassRegistry::init('EvCore.EvCorePermission');
	}

/**
 * Sync the ACO table
 *
 * @param array $params The parameters to use to check for permissions.
 * @return void
 **/
	public function aco_sync($params = array()) {
		$this->_clean = true;
		$this->aco_update();
	}

/**
 * Updates the Aco Tree with new site setting categories and site settings.
 *
 * @return void
 **/
	public function aco_update() {
		// Check the nodes exist for each user group
		$root = $this->_checkNode($this->rootNode, $this->rootNode, null);

		$UserGroup = EvClassRegistry::init('EvCore.UserGroup');
		$userGroups = $UserGroup->find('list');

		foreach ($userGroups as $userGroupId => $userGroupName) {
			$permissionName = 'impersonateGroup' . $userGroupId;
			$this->_checkNode($this->rootNode . '/' . $permissionName, $permissionName, $root['Aco']['id']);
		}

		$this->out(__('<success>Aco Update Complete</success>'));
		return true;
	}

/**
 * Sets the default permissions for Admins and Super Users to be able to impersonate users.
 * If this is different on a certain project, this function will need to be overridden
 *
 * @return void
 */
	public function setDefaultAccess() {
		// Block all groups by default
		$UserGroup = EvClassRegistry::init('EvCore.UserGroup');
		$userGroups = $UserGroup->find('list');
		foreach ($userGroups as $userGroupId => $userGroupName) {
			$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => $userGroupId], 'impersonations', '*', -1);
			foreach ($userGroups as $blockUserGroupId => $blockUserGroupName) {
				$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => $userGroupId], 'impersonations/impersonateGroup' . $blockUserGroupId, '*', -1);
			}
		}

		// Give super users and admins the general impersonate permission
		$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => 1], 'impersonations', '*', 1);
		$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => 2], 'impersonations', '*', 1);

		// Allow super users and admins to impersonate users
		$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => 1], 'impersonations/impersonateGroup3', '*', 1);
		$this->_Permission->allow(['model' => 'UserGroup', 'foreign_key' => 2], 'impersonations/impersonateGroup3', '*', 1);
	}

/**
 * Check a node for existance, create it if it doesn't exist.
 *
 * @param string $path The path to use to check for the node.
 * @param string $alias The alias of the node to create if the node is missing.
 * @param int $parentId The parent id to associate with this node.
 * @return array Aco Node array
 */
	protected function _checkNode($path, $alias, $parentId = null) {
		$node = $this->Aco->node($path);
		if (!$node) {
			$this->Aco->create(array('parent_id' => $parentId, 'model' => null, 'alias' => $alias));
			$node = $this->Aco->save();
			$node['Aco']['id'] = $this->Aco->id;
			$this->out(__('Created Aco node: <success>%s</success>', $path), 1, Shell::VERBOSE);
		} else {
			$node = $node[0];
		}
		return $node;
	}
}
