EvImg - Image Resizer Plugin
============================

This plugin adds an Img Helper for resizing and caching images using Imagick. Imagick must be installed on the server this is being used on.

The plugin optimises generated images reducing filesizes by ~50% comparred with EvImage.

Installation
------------

This plugin should be installed using Composer:-

    composer require evoluted/img:2.*

Then add the following line to your bootstrap.php to load the plugin (`unless you are using CakePlugin::loadAll()`).

    CakePlugin::load('EvImg');

Usage
-----

To output an `<img>` tag with resized image use the `resize()` method passing either an image path or image array as the first parameter:-

    <?php echo $this->Img->resize($image, ['width' => 400, 'height' => 300], ['class' => 'full']); ?>

The second parameter is an array of image dimensions.

The third parameter is any tag attributes you want applying to the `<img>` tag and/or a `url` attribute to link the image.

There is an optional fourth attribute for passing the image context. This is a string that defines the directory the resized image is to be cached to. This defaults to `$image['id']` when passing an image array as the first parameter.

You can retrieve just the image path using `path()`:-

    <?php echo $this->Img->path($image, ['width' => 400, 'height' => 300]); ?>

The image dimensions are deliberately kept in a separate array to the attributes so that you can define image dimensions elsewhere in your app for consistency. For example, you could define `$thumbnail` in your AppController and then use it like:-

	<?php echo $this->Img->resize($image, $thumbnail, ['class' => 'full']); ?>

The dimensions options are:-

 * `(int)width` - image width
 * `(int)height` - image height
 * `(bool)fit` - fits the image to defined `width` and `height` without upscaling
 * `(bool)fill` - fits the image to defined `width` and/or `height` with upscaling
 * `(bool)crop` - crops the image to defined `width` and `height`
 * `(bool)pdf` - to generate a thumbnail of a PDF file (not required when passing the file as an array)
 * `(string)background` - image background colour
 * `(string|array)cropPosition` - Position to crop from. Accepted values are "top", "middle", "bottom" or an array with x and y keys defined. The x and y values should be relative to the new image size rather than the original
 * `(bool|array)blur` - blurs the image, set to true to use default blur settings or set to an array with "radius" and "sigma" keys to customise the level of blur

If you only define one of `width` or `height` it will scale the image according to that, otherwise it will scale to which ever is closest to the image's ratio (unless `fit` or `crop` are defined).

Remoted Images
--------------

You can use this plugin to resize remote images, but in order to do this the remote file needs caching locally.

The `remoteCacheDirectory` setting defines the folder where remote files will get cached.

Lazy Loading
--------------

All images that pass through the `resize` method will now be lazy loaded by default.

This means they will use a generic SVG placeholder, or a placeholder that has been passed in
as an option until they need to be loaded.

You can pass the `immediate` flag to the `resize` method to prevent lazy loading on that asset.

Lazy load can be disabled via the `config` using the `lazyload` property. This will allow you to configure
the package on a per-project basiss if needed.