<?php

$config = [
	'EvImg' => [

		/*
		 * Enable lazy load (true) to return a placeholder image when resizing an image using the ImgHelper with data
		 * attributes to load the actual image after page load.
		 */
		'lazyload' => false,
		'lazyLoadPlaceholder' => '', //Asset path for lazy load placeholder image, e.g. /img/lazy_load_placeholder.svg

		/*
		 * Setup caching for different areas of ImgHelper. Set to true to enable caching, false to disable. Or set to
		 * "production" to only cache on production environments.
		 */
		'cache' => [
			'imgPath' => 'production', // Cache the generated image path for a specific image, dimensions and context.
			'resize' => 'production', // Cache the generated image html for a specific image, dimensions, options and context.
		],

		/*
		 * Set the duration of cached ImgHelper values. Set to null to use the default. Examples: '+10 seconds', '+999 days'.
		 */
		'cacheDuration' => null,

		/*
		 * Enable WEBP support
		 * Offers far better compression for the same quality as JPEG conversion
		 * Massive compression gains for PNGs with minimal loss in quality
		 * Some servers/local environments may have limited support
		 */
		'webp' => false,

		/**
		 * Force full dimensions on <img> tag
		 */
		'forceImageSizeAttributes' => false,
	],
];
