<?php

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);

Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {
	Configure::load($configOverride);
}

// Setup img caching config
$engine = 'File';
if (extension_loaded('apc') && function_exists('apc_dec') && (php_sapi_name() !== 'cli' || ini_get('apc.enable_cli'))) {
	$engine = 'Apc';
}

$duration = Configure::read('EvImg.cacheDuration');
if (empty($duration)) {
	$duration = '+999 days';
	if (Configure::read('debug') >= 1) {
		$duration = '+10 seconds';
	}
}

Cache::config(
	'EvImg.ImgCaching',
	[
		'engine' => $engine,
		'duration' => $duration,
		'prefix' => getCachePrefix(),
		'path' => CACHE . 'EvImg' . DS . 'ImgCaching' . DS,
	]
);
