<?php

App::uses('AppComponent', 'Controller/Component');

class ImagesComponent extends Component {

/**
 * Actions to perform before page is rendered
 *
 * {@inheritDoc}
 */
	public function beforeRender(Controller $controller) {
		parent::beforeRender($controller);

		$this->_loadPlaceholderImage();
	}

/**
 * Add default placeholder image path to config
 *
 * @return void
 */
	protected function _loadPlaceholderImage() {
		if (!empty(Configure::read('EvImage.defaultPlaceholderImageName'))) {
			$View = new View($this->_controller, false);

			$defaultPlaceholderImagePath = $View->Html->assetUrl(Configure::read('EvImage.defaultPlaceholderImageName'), ['pathPrefix' => 'img/']);
			Configure::write('EvImage.defaultPlaceholderImagePath', $defaultPlaceholderImagePath);
		}
	}

}
