#EvGoogleServices

This package allows easy communication and integration with Google Services that make use of their OAuth2 based API.

Individual services (e.g Aaalytics, YouTube, PageSpeed Insights) have their own API commands however Google uses a single API for all of these. This package acts as a bridge between our CMS and those API's.

Each api we use gets its own library and component. The library uses the provided Google library to set up it's own api connection. You can then either provide full access to the api via the library, or build a set of reusable api calls.

##Adding New Service Calls / Contributing
If you wish to add a new service, take a look at the Analytics library provided as a basis to work from. You should commit your addition back into this repo as another library file and component.

Please also include a markdown readme specific to your library.

##Authentication Setup
This plugin makes use of service account authentication via OAuth. To create a service account, go to your [developer console credentials page](https://console.developers.google.com/apis/credentials) and click 'Create Credentials' and select 'Service Account Key'.

On the next page select the service account you wish to use (note that this will be a user account that must have permissions to access whatever service you're working with) and select JSON as the key type.

A JSON file will then download - this is required for your project to authenticate. Place this in your app/tmp directory (feel free to give it a nicer name) and update your EvGoogleServices config file with the path to the json file. You'll also be able to see the user account details at this stage. Copy the email address (also known as the service account id) and place this into your config file.

Back on your credentials page of your developer console you'll see your new service account key, confirming it was successfully created. Assuming you've set the correct path to the json file, and the email address / service account id in your config file, you should now be all ready to use this plugin!

##External Resources

* [Google PHP Api Client](https://github.com/google/google-api-php-client) (Used by this package)
* [Google Developer Documentation](https://developers.google.com/products/)
* [Google API Query Explorer Tool](https://ga-dev-tools.appspot.com/query-explorer/)
* [Google Developer Console](https://console.developers.google.com)