<?php

class Google {

	public $client;

	public function __construct() {
		$this->client = new Google_Client();
		$this->client->setApplicationName(Configure::read('EvGoogleServices.applicationName'));
	}

	/**
	 * Completes the authentication. This should be called after you've initialised your scope/service.
	 * @return void
	 */
	public function auth() {
		putenv('GOOGLE_APPLICATION_CREDENTIALS=' . Configure::read('EvGoogleServices.keyFilePath'));
		$this->client->useApplicationDefaultCredentials();

		$this->client->authorize();

		if ($this->client->isAccessTokenExpired()) {
			$this->client->refreshTokenWithAssertion();
		}
	}
}
