<?php

App::uses('Google', 'EvGoogleServices.Lib');

class Drive extends Google {

	public $svc;

	public $profileId;

	public $defaultSearchParams = [
		'spaces' => 'drive'
	];

	public function __construct() {
		// Set up the Google API
		parent::__construct();

		// Set the scope path and load up the service
		$this->client->addScope("https://www.googleapis.com/auth/drive.readonly");
		$this->svc = new Google_Service_Drive($this->client);

		// Authenticate so we can start using this service
		$this->auth();
	}

/**
 * Find a file/files on a Google Drive
 * API docs:
 * -- https://developers.google.com/drive/api/v3/search-parameters
 * Example usage:
 * -- https://github.com/gsuitedevs/php-samples/blob/master/drive/quickstart/quickstart.php#L83 (and onward)
 *
 * @param array $params An array of search params to use in Search
 * @return object(Google_Service_Drive_FileList) $results The results of the search
 */
	public function search($params) {
		$params = array_merge_recursive($params, $this->defaultSearchParams);

		$results = $this->svc->files->listFiles($params);

		return $results;
	}
}
