#Analytics API
This document outlines the basics of how to use the Analytics API library within EvGoogleServices.

Out of the box the plugin supports retrieving standard and unique pageviews both site-wide and on specific pages with optional support for setting date ranges.

Additional calls can be made (and should be contributed back into the Analytics library file!) if needed.

##Setup / Usage
Install the plugin and copy out the config file into your project, updating it with your site details.

Once setup you can either call the library directly, or use the provided component. If you are using the component you should load it into your controller like so:

````
if (CakePlugin::loaded('EvGoogleServices')) {
    $this->components[] = 'EvGoogleServices.Analytics';
}
````

Once loaded, you can use the following commands:

###Get all unique pageviews for a specific path between two dates:
````
$pageViews = $this->Analytics->api->getPageViews('/about-us', '2016-04-20', '2016-04-27', true);
````

###Get all pageviews for a specific path on a fixed dates:
````
$pageViews = $this->Analytics->api->getPageViews('/about-us', '2016-04-20');
````

###Get site-wide unique pageviews between two dates:
````
$pageViews = $this->Analytics->api->getTotalViews('2016-04-20', '2016-04-27', true);
````

###Get site-wide pageviews between two dates:
````
$pageViews = $this->Analytics->api->getTotalViews('2016-04-20', '2016-04-27');
````

