jQuery(document).ready(function($) {

	// set default params
	var evGalleryOptions = {
		auto: true,
		pagerCustom: null,
		nextSelector: null,
		nextText: '',
		prevSelector: null,
		prevText: ''
	}

	// check to see whether we are using thumbnails, assign if so
	if ($('.ev-gallery__bxslider__thumbs', '.ev-gallery').children('a').length > 0) {
		evGalleryOptions.pagerCustom = '.ev-gallery__bxslider__thumbs';
	}

	// check to see whether we are using next controls, assign if so
	var nextClass = '.ev-gallery__bxslider__controls__next';
	if (
		typeof $(nextClass, '.ev-gallery') != 'undefined'
		&& $(nextClass, '.ev-gallery').length > 0
	) {
		evGalleryOptions.nextSelector = nextClass;
		evGalleryOptions.nextText = '';
	}

	// check to see whether we are using prev controls, assign if so
	var prevClass = '.ev-gallery__bxslider__controls__prev';
	if (
		typeof $(prevClass, '.ev-gallery') != 'undefined'
		&& $(prevClass, '.ev-gallery').length > 0
	) {
		evGalleryOptions.prevSelector = prevClass;
		evGalleryOptions.prevText = '';
	}

	// init bxslider
	$('.bxslider', '.ev-gallery').bxSlider(evGalleryOptions);

	// listener for the select gallery select element
	if ($('.ev_gallery_select_gallery', '.ev-gallery').length > 0) {
		$(document).on('change', '.ev-gallery .ev_gallery_select_gallery', function() {

			window.location = '/gallery/view/' + this.value;
			return false;
		});
	}

});