<div class="ev-gallery">

	<?php
		if (isset($page['Page']) & !empty($page['Page'])) {

			echo '<h1>' . $page['Page']['title'] . '</h1>';

			echo $page['Page']['body'];
		} else {

			echo '<h1>' . $data['Gallery']['name'] . '</h1>';
		}
	?>

	<?php
		if (isset($galleryListing) && !empty($galleryListing)) {
			echo $this->element('EvGallery.select_gallery');
		}
	?>

	<?php
		if (isset($data['Image']) && !empty($data['Image'])):

			$dimensions = Configure::read('EvGallery.dimensions');

			$bxSliderCss = $this->Html->style(array(
				'max-height' => $dimensions['main']['height']
			));
	?>
		<div class="ev-gallery__bxslider__wrapper">
			<ul class="bxslider" <?php echo $bxSliderCss; ?>>
			<?php


				$i = 0;
				foreach ($data['Image'] as $image) {
					$alt = (!empty($image['alt']) ? $image['alt'] : $data['Gallery']['name'] . ' ' . ($i+1));

					echo '<li>' . $this->Image->resize($image, array(
						'alt' => $alt,
						'crop' => true,
						'height' => $dimensions['main']['height'],
						'upscale' => true,
						'width' => $dimensions['main']['width']
					)) . '</li>';

					$i++;
				}
			?>
			</ul>

			<?php
				$showThumbs = Configure::read('EvGallery.showThumbs');

				if (isset($showThumbs) && $showThumbs == true) {
					echo $this->element('EvGallery.thumbnails', array(
						'data' => $data,
						'dimensions' => $dimensions['thumbnail']
					));
				}
			?>

		</div>
	<?php
		else:
			echo '<p>There are no results to show.</p>';
		endif;
	?>

</div>

<?php

	// load css
	echo $this->Html->css(array(
		'/ev_gallery/js/vendor/bxslider/jquery.bxslider',
		'EvGallery.ev-gallery'
	), array('inline' => false));

	// load javascript
	echo $this->Html->script(array(
		'/ev_gallery/js/vendor/bxslider/jquery.bxslider.min',
		'EvGallery.jquery.main'
	), array('inline' => false));

?>