<?php

App::uses('EvGalleryAppModel', 'EvGallery.Model');

class Gallery extends EvGalleryAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'config' => 'EvGallery'
		),
		'MetaData.Meta',
		'Tree'
	);

	public $imageSlots = -1;

	public $order = array(
		'Gallery.created' => 'DESC'
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required field'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters long'
			)
		),
	);

}