<?php

App::uses('EvGalleryAppController', 'EvGallery.Controller');

class GalleriesController extends EvGalleryAppController {


	public function beforeFilter() {

		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view'
		));

	}


/**
 * Index
 *
 * Returns the requested image gallery
 */
	public function index() {

		// if set then find and assign page data
		$pageId = Configure::read('EvGallery.pageId');

		if (isset($pageId) && !empty($pageId)) {

			ClassRegistry::init('Page');
			$Page = new Page();

			$pageData = $Page->readForView($pageId);
			$this->set('page', $pageData);

			// assign page meta data
			$this->Meta->set($pageData);
		}

		$this->view();

		$this->view = 'EvGallery.Galleries/view';
	}


/**
 * View
 *
 * Returns the requested image gallery
 */
	public function view($id = null) {

		// Model instance
		$Model = $this->{$this->modelClass};

		// find and assign listing of available galleries
		$this->set('galleryListing', $this->Gallery->generateTreeList());

		// if no gallery is requested the return the first we find
		if (!$id) {
			$id = $Model->field('id', array('Gallery.is_active' => true), 'Gallery.lft ASC');
		}

		// find and assign listing of gallery
		$data = $Model->readForView($id);

		if (!isset($data) || empty($data)) {
			throw new NotFoundException();
		}

		$this->set('data', $data);

		// assign page meta data
		$this->Meta->set($data);

		$this->view = 'EvGallery.Galleries/view';
	}

}