<?php
die('EvFrontendCard is not currently a composer plugin!');
// ╔═════════════════════════════════════════════════════════════════════════════════════════╗
// ║ Card                                                                                    ║
// ║                                                                                         ║
// ║ @param  string       $class         Extra classes for card element                      ║
// ║ @param  bool         $responsive    (true) If false, this will stop responsive styles.  ║
// ║ @param  string|array $url           Url for card in general (literal or cake link array)║
// ║ @param  string|date  $thumb         Either image html, or date object                   ║
// ║ @param  string       $download      If a download link, set to file type such as        ║
// ║                                     archive, audio, code, excel, image, pdf, powerpoint,║
// ║                                     text, video, word, or '' for empty icon.            ║
// ║ @param  string       $heading                                                           ║
// ║ @param  assoc array  $subheadings   Items below header with generated classes           ║
// ║                                     Accepts anything, but specifically handles:         ║
// ║                                     Dates (puts into d/m/Y format)                      ║
// ║                                     Urls (literal or cake link array)                   ║
// ║ @param  string       $contentImage  Image html to go within .card__content              ║
// ║ @param  string       $content       Any unescaped html content                          ║
// ║ @param  string       $social        Pass HTML for social links - perhaps via an element ║
// ║ @param  bool         $thumbTabbing  (false) Enable keyboard tabbing to thumbnail <a>    ║
// ╚═════════════════════════════════════════════════════════════════════════════════════════╝
?>
<?php
	if (!method_exists($this->Html, 'flexiLink')):
		die("EvFrontendCard requires function 'flexiLink' to be in HtmlExtHelper.php - as it is not currently extended in it's own helper.");
	endif;

	// Build up the .card classes
	if (empty($class)) $class = '';
	$class .= ' card';
	if (isset($responsive) &&
		$responsive == false) $class .= ' card--nonresponsive';
	if (!empty($thumb))       $class .= ' card--has-thumb';
	if (isset($download))     $class .= ' card--has-thumb card--download card--download--' . $download;

	// Start building the link if need be, supporting internal and external types
	if (!empty($url)): // simple link string
		if (!is_array($url)): // simple link string
			$link = ['url' => $url];
		else:
			$link = $url;
		endif;
	endif;
?>
<div class="<?= $class; ?>">
	<?php
		if (isset($download)) $thumb = true;

		// If has a typical thumb
		if (!empty($thumb)):
			echo '<div class="card__thumb">';

			// Create thumb HTML
			$thumbHtml = '';

			// Thumb image
			if (is_string($thumb)):
				/*
				$thumbHtml .= $this->Html->image($thumb, [
					'alt' => '', // typically unnecessary
					'width' => 180,
					'height' => 180,
					'class' => 'card__thumb__image',
				]);
				*/
				// Assume '<img ..' markup given, allowing for images to be externally resized.
				$thumbHtml .= $thumb;

			// Thumb date
			elseif (!is_bool($thumb)):
				$thumbHtml .= '<div class="card__thumb__date">';
				$thumbHtml .= '<span>'.Date('d', $thumb).'</span> ';
				$thumbHtml .= '<span>'.strtoupper(Date('M', $thumb)).'</span>';
				$thumbHtml .= '</div>';
			endif;

			// Thumb download file type
			if (isset($download)):
				$thumbHtml .= '<div class="card__thumb__icon">';
				if ($download == ''):
					$thumbHtml .= '<i class="fa fa-file-o"></i>';
				else:
					$thumbHtml .= '<i class="fa fa-file-'.$download.'-o"></i>';
				endif;
				$thumbHtml .= '</div>';
			endif;

			// echo thumb as a link if provided
			if (!empty($link)):
				// Put thumb html as the content of the link
				$thumbLink = $link;
				$thumbLink['title'] = $thumbHtml;

				// Add options array if needed
				if (empty($thumbLink['options'])) $thumbLink['options'] = [];

				// Built-in options
				$thumbLink['options']['escape'] = false;
				if (empty($thumbTabbing)) $thumbLink['options']['tabindex'] = "-1";

				#debug($thumbLink); die();
				#debug($this->Html->flexiLink($thumbLink)); die();
				$thumbHtml = $this->Html->flexiLink($thumbLink);
			endif;

			// echo thumb with or without a link
			echo '<span>' . $thumbHtml . '</span>';

			echo '</div>';
		endif;
	?>
	<div class="card__content">
		<div class="wysiwyg">
			<?php if (!empty($contentImage)): ?>
				<div class="card__content__image">
					<?= $contentImage; ?>
				</div>
			<?php endif; ?>

			<?php if (!empty($heading)): ?>
				<div class="card__title">
					<?php
						if (!empty($link)):
							$titleLink = $link;
							$titleLink['title'] = $heading;
							echo $this->Html->flexiLink($titleLink);
						else:
							echo $heading;
						endif;
					?>
				</div>
			<?php endif; ?>

			<?php if (!empty($subheadings)): ?>
				<div class="card__subheadings">
					<?php
						/**
						 * Subheading elements
						 * Create lovely little spans with predictable classnames, e.g.
						 * .card__subheading.card__subheading--date
						 **/
						foreach ($subheadings as $key => $val):
							if (!empty($val)):
								// Handle various subheading types
								switch ($key):
									case "url":
										// if empty link title or url, hide this subheading
										if (empty($val['title']) || empty($val['url'])):
											$val = null;
											break;
										else:
											$val = $this->Html->flexiLink($val);
										endif;
										break;

									case "date":
										$val = Date("d/m/Y", $val);
										break;

									default;
										break;
								endswitch;

								if (!empty($val)): // may well be empty again at this point
									echo '<span class="card__subheading card__subheading--' . InflectorExt::snake($key) . '">';
										echo $val;
									echo '</span>';
								endif;
							endif;
						endforeach;
					?>
				</div>
			<?php endif; ?>

			<?php if (!empty($content)): ?>
				<?= $content; ?>
			<?php endif; ?>
		</div>

		<?php if (!empty($social)): ?>
			<?= $social; ?>
		<?php endif; ?>
	</div>

</div>
