Form Helper
===========

Usage
-----

### Form::radio()

This is an extended version of Cake's `radio` method that adds additional markup so that radio buttons are easier to work with. Each input-label pair is wrapped in a `div` that you can set the class of using `wrapInput`; and all the inputs are wrapped in another `div` that you can set the class of using `wrapInputs`.

To set a class on the fieldset's legend you can pass an array containing `class` and `text` (for the legend's text). This is an extension of Cake's usual behaviour but consistent with how it handles `input` labels.

For example:-

	echo $this->Form->radio(
		'colours',
		['red', 'green', 'blue'],
		[
			'legend' => [
				'class' => 'col-xs-12 col-md-4 control-label',
				'text' => 'Select a colour'
			],
			'wrapInput' => 'inline-radio radio',
			'wrapInputs' => 'col-xs-12 col-sm-7'
		]
	);

If you need to remove the legend/fieldset set `legend => false` as you normally would with Cake. Remember for accessibility radio buttons should have a fieldset and legend.

The method uses the `separator` attribute for determining where the split between the inputs is so override this with caution!

Should you need to override the wrapInput on an individual radio options this can be attained by passing through
an array in place of the radio option value for the particular radio option

For example:-

	echo $this->Form->radio(
		'colours',
		[
			[
				'name' => 'red',
				'wrapInput' => 'inline-radio radio radio--red'
			],
			'green',
			'blue'
		],
		[
			'legend' => [
				'class' => 'col-xs-12 col-md-4 control-label',
				'text' => 'Select a colour'
			],
			'wrapInput' => 'inline-radio radio',
			'wrapInputs' => 'col-xs-12 col-sm-7'
		]
	);

### Form::yesOrNo()

This provides a simple select or radio element with the options 'yes' (1/`true`) and 'no' (0/`false`).

	echo $this->Form->yesOrNo('do_you_like_cake');

You can reverse the order of the options by passing `reverseOptions` like this:-

	echo $this->Form->yesOrNo('do_you_like_cake', ['reverseOptions' => true]);

To use as radio inputs pass the `radio` type:-

	echo $this->Form->yesOrNo('do_you_like_cake', ['type' => 'radio']);

### Form::isFieldsError()

Checks whether one or more of the passed field names currently has an active validation error.

	if ($this->Form->isFieldsError(['foo', 'bar'])):
		echo 'Error';
	endif;

This works by calling `isFieldError()` for each of the field names.

### Form::recaptcha()

Returns a reCAPTCHA-ready form element, using the form input defaults as a basis for the reCAPTCHA element output with the aim of the field laying out seamlessly on the template with further form fields.

You will need to register a new ReCaptcha entry at https://www.google.com/recaptcha/admin. This will present you with two keys, a site key and a secret key. These need to be added to the EvCore config as follows:

```
<?php
	'EvCore' => [
		'userReCaptcha' => [
			'siteKey' => '...',
			'secret' => '...',
		],
	],
```

Two types of recaptcha are supported in the plugin. The version 2 checkbox recaptcha that requires users to check the box and pass the challenge, and the version 3 invisible recaptcha that tracks user interaction with the page and determines whether they pass or not depending on their actions. By default the version 2 checkbox recaptcha is used. You can switch the type by passing the `recaptchaType` input attribute. The types need to be passed as follows:

* Version 2 Checkbox - `V2Checkbox`
* Version 3 Invisible - `V3Invisible`

### Form::invisibleRecaptcha()

Behaves the same as above but hides the recaptcha as the submit button. This type should replace the usual submit button and should be compatible with the existing parameters.

### Form::fontawesomePicker()

Returns an icon picker based on fontawesome-iconpicker. It allow the user to visually select an icon and outputs the class name (e.g. `fa-truck`). The text field at the top of the popup can be used to search for an icon. To use with admin fields set the field type to `fontawesome-picker`.

### Google Maps

The ability to render Google Maps is available out of the box. The plugin expects a field name of `map_data` of type TEXT. When a `map_data` field is recognised a Google Map with location input element is render on the admin template.

Also, now might also be a good time to request a project specific [Google Maps API key](https://developers.google.com/maps/documentation/javascript/get-api-key#key).


### TinyMCE

There are three instances of the TinyMCE jQuery plugin available to use. These can be accessed by updating `type` attribute of the admin form element through the `_adminFormFields` method in `EvCore`.

#### `html`

Allows for all typical HTML content elements, such as paragraphs (inc. `strong` and `em`), links, headings (H2 and above), tables, lists etc.

#### `text` or `html_lite`

The default instance, used heavily across `core-cms` admin form templates. A limited version of the `html` instance, allowing paragraphs (inc. `strong` and `em`), links, headings (H2 and above), lists and blockquotes.

#### `html_xs`

A limited instance of TinyMCE, allowing only paragraphs (inc. `strong` and `em`) and links.

### Chosen Multiselect

Best suited to situations when you need to choose multiple options from a long list. The type should be `chosen_multiselect`. Use like a select if you only need the default configuration as all JS is handled by the plugin. If you need to specify configuration options then add a `chosen_options` field to the attributes array when building a form. Configuration options can be found [here](https://harvesthq.github.io/chosen/options.html) and will be applied to individual instances.

### Display Only

Adds fields with the markup for just html no editable.

##### Display attributes

* Array "url" - The values can be turned into links by providing a "url" attribute. The value of the field becomes the link text and the url attribute array becomes the link url. If data needs to be added to the url then provide a data path as an attribute of the url like:

```
 [
     'url' => [
         'dataPath' => 'ModelAlias.ModelAlias.id',
     ],
]
```

The dataPath attribute can be an array if multiple pieces of data need to be added to the url.

* Bool "display_id" - If a field is of type: `multiselect`, `multicheck`, `select`, `radio` or ends with `_id` then the field will be displayed as an Id field. If the options aren't provided on the field or as populated data then provide this to show the id, otherwise it will be displayed as `-` even if the data is available.



Development
-----------

When developing with EvForm please make sure that the unit tests run successfully and add tests for any new features you add. If you find a bug and fix it add a test case to ensure that the bug is resolved and doesn't get broken again.

To run a test against the FormExt Helper you can run `app/Console/cake test EvForm View/Helper/FormExtHelper` via command line.

If you don't know how unit testing works in CakePHP ask!
