<?php
	if (empty($siteKey)) return '';

	$fieldName = !empty($fieldName) ? $fieldName : '';
	$fieldAttributes = !empty($fieldAttributes) ? $fieldAttributes : [];

	$action = !empty($fieldAttributes['action']) ? $fieldAttributes['action'] : 'formSubmission';
	unset($fieldAttributes['action']);

	echo $this->Html->script(
		'https://www.google.com/recaptcha/api.js?render=' . $siteKey,
		[
			'block' => 'script',
			'once' => true,
		]
	);
?>

<?php
	$this->Html->scriptStart(
		[
			'block' => 'script',
		]
	);
?>
	grecaptcha.ready(function() {
		document.querySelector('[data-g-recaptcha]').closest('form').addEventListener(
			'submit',
			function (event) {
				const form = event.target;

				event.preventDefault();

				grecaptcha.execute(
			    	'<?= $siteKey ?>',
			    	{
			    		action: '<?= $action ?>'
			    	}
			    ).then(
			    	function(token) {
			    		form.querySelector('[data-g-recaptcha]').value = token;
			    		form.submit();
			    	}
			    );

			    <?= $this->fetch('formSubmitActions') ?>
			}
		);

	    <?= $this->fetch('actions') ?>
	});
<?= $this->Html->scriptEnd() ?>

<?php
	echo $this->Form->input(
		$fieldName,
		[
			'type' => 'hidden',
			'data-g-recaptcha' => '',
			'required' => '',
		]
	);
?>
