<?php
App::uses('Controller', 'Controller');
App::uses('View', 'View');
App::uses('HtmlHelper', 'View/Helper');
App::uses('FormExtHelper', 'EvForm.View/Helper');

class FormExtHelperTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$Controller = new Controller();
		$View = new View($Controller);
		$this->Form = new FormExtHelper($View);
	}

	public function testRadio() {
		$result = $this->Form->radio('colours', ['red', 'green', 'blue']);
		$expected = '<fieldset><legend class="col-md-3 control-label">Colours</legend><div class="col-md-9"><div class="radio"><input type="hidden" name="data[colours]" id="colours_" value=""/><label class="radio" for="colours0"><input type="radio" name="data[colours]" id="colours0" value="0" wrapInput="radio" wrapInputs="col-md-9" /> red</label></div>
<div class="radio"><label class="radio" for="colours1"><input type="radio" name="data[colours]" id="colours1" value="1" wrapInput="radio" wrapInputs="col-md-9" /> green</label></div>
<div class="radio"><label class="radio" for="colours2"><input type="radio" name="data[colours]" id="colours2" value="2" wrapInput="radio" wrapInputs="col-md-9" /> blue</label></div></div></fieldset>';
		$this->assertEquals($expected, $result);
	}

	public function testRadioCustomLegend() {
		$result = $this->Form->radio('colours', ['red', 'green', 'blue'], ['legend' => 'Foo bar']);
		$expected = '<fieldset><legend>Foo bar</legend><div class="col-md-9"><div class="radio"><input type="hidden" name="data[colours]" id="colours_" value=""/><label class="radio" for="colours0"><input type="radio" name="data[colours]" id="colours0" value="0" wrapInput="radio" wrapInputs="col-md-9" /> red</label></div>
<div class="radio"><label class="radio" for="colours1"><input type="radio" name="data[colours]" id="colours1" value="1" wrapInput="radio" wrapInputs="col-md-9" /> green</label></div>
<div class="radio"><label class="radio" for="colours2"><input type="radio" name="data[colours]" id="colours2" value="2" wrapInput="radio" wrapInputs="col-md-9" /> blue</label></div></div></fieldset>';
		$this->assertEquals($expected, $result);
	}

	public function testRadioWithoutLegend() {
		$result = $this->Form->radio('colours', ['red', 'green', 'blue'], ['legend' => false]);
		$expected = '<div class="col-md-9"><div class="radio"><input type="hidden" name="data[colours]" id="colours_" value=""/><label class="radio" for="colours0"><input type="radio" name="data[colours]" id="colours0" value="0" wrapInput="radio" wrapInputs="col-md-9" /> red</label></div>
<div class="radio"><label class="radio" for="colours1"><input type="radio" name="data[colours]" id="colours1" value="1" wrapInput="radio" wrapInputs="col-md-9" /> green</label></div>
<div class="radio"><label class="radio" for="colours2"><input type="radio" name="data[colours]" id="colours2" value="2" wrapInput="radio" wrapInputs="col-md-9" /> blue</label></div></div>';
		$this->assertEquals($expected, $result);
	}

	public function testRadioWithoutFieldset() {
		$result = $this->Form->radio('colours', ['red', 'green', 'blue'], ['legend' => false]);
		$expected = '<div class="col-md-9"><div class="radio"><input type="hidden" name="data[colours]" id="colours_" value=""/><label class="radio" for="colours0"><input type="radio" name="data[colours]" id="colours0" value="0" wrapInput="radio" wrapInputs="col-md-9" /> red</label></div>
<div class="radio"><label class="radio" for="colours1"><input type="radio" name="data[colours]" id="colours1" value="1" wrapInput="radio" wrapInputs="col-md-9" /> green</label></div>
<div class="radio"><label class="radio" for="colours2"><input type="radio" name="data[colours]" id="colours2" value="2" wrapInput="radio" wrapInputs="col-md-9" /> blue</label></div></div>';
		$this->assertEquals($expected, $result);
	}

	public function testAddFieldSlug() {
		// Set HTTP Host for testing.
		$_SERVER['HTTP_HOST'] = 'example.com';

		// Test a standard slug alias field.
		$result = $this->Form->addField('Route.alias', ['type' => 'slug']);

		$expected = '<div class="form-group"><label for="RouteAlias" class="col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label">URL</label><span class="non-edit base-url">http://example.com/</span><span class="non-edit route"><span class="slug-display"></span> <a href="#" class="edit-route btn btn-primary btn-sm"><i class="fa fa-pencil"></i> Edit URL</a></span><div class="input-edit-slug"><div class="col-xs-12 col-sm-10 col-md-9 col-lg-10"><input name="data[Route][alias]" empty="" class=" form-control" value="" type="slug" id="RouteAlias"/></div><a href="#" class="stop-editing btn btn-success"><i class="fa fa-check"></i> Done</a></div></div>';
		$this->assertEquals($expected, $result);

		return;
	}

	public function testAddFieldPrefixedSlug() {
		// Set HTTP Host for testing.
		$_SERVER['HTTP_HOST'] = 'example.com';

		// Test a prefixed slug alias field.
		$result = $this->Form->addField('Route.alias', ['type' => 'slug', 'url_prefix' => 'foo', 'value' => 'foo/bar']);
		$expected = '<div class="form-group"><label for="RouteAlias" class="col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label">URL</label><span class="non-edit base-url">http://example.com/foo/</span><span class="non-edit route"><span class="slug-display">bar</span> <a href="#" class="edit-route btn btn-primary btn-sm"><i class="fa fa-pencil"></i> Edit URL</a></span><div class="input-edit-slug"><div class="col-xs-12 col-sm-10 col-md-9 col-lg-10"><input name="data[Route][alias]" empty="" class=" form-control" value="bar" data-url-prefix="foo" type="slug" id="RouteAlias"/></div><a href="#" class="stop-editing btn btn-success"><i class="fa fa-check"></i> Done</a></div></div>';
		$this->assertEquals($expected, $result);

		return;
	}

	/**
	 * Test the basic yesOrNo field element
	 * @return void
	 */
	public function testYesOrNo() {
		$result = $this->Form->yesOrNo('foo');
		$result = str_replace("\n", '', $result);
		$expected = '<div class="form-group"><label for="foo" class="col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label">Foo</label><div class="col-xs-12 col-sm-10 col-md-9 col-lg-10"><select name="data[foo]" class="form-control" id="foo"><option value=""></option><option value="1">Yes</option><option value="0">No</option></select></div></div>';
		$this->assertEquals($expected, $result);
	}

	/**
	 * Test reverse yesOrNo field element
	 * @return void
	 */
	public function testYesOrNoReverse() {
		$result = $this->Form->yesOrNo('foo', ['reverseOptions' => true]);
		$result = str_replace("\n", '', $result);
		$expected = '<div class="form-group"><label for="foo" class="col-xs-12 col-sm-2 col-md-3 col-lg-2 control-label">Foo</label><div class="col-xs-12 col-sm-10 col-md-9 col-lg-10"><select name="data[foo]" class="form-control" id="foo"><option value=""></option><option value="0">No</option><option value="1">Yes</option></select></div></div>';
		$this->assertEquals($expected, $result);
	}

	/**
	 * Test radio yesOrNo field element
	 * @return void
	 */
	public function testYesOrNoRadio() {
		$result = $this->Form->yesOrNo('foo', ['type' => 'radio']);
		$result = str_replace("\n", '', $result);
		$expected = '<fieldset><legend class="col-md-3 control-label">Foos</legend><div class="col-md-9"><div class="radio"><input type="hidden" name="data[foo]" id="foo_" value=""/><label class="radio" for="foo1"><input type="radio" name="data[foo]" id="foo1" value="1" wrapInput="radio" wrapInputs="col-md-9" /> Yes</label></div><div class="radio"><label class="radio" for="foo0"><input type="radio" name="data[foo]" id="foo0" value="0" wrapInput="radio" wrapInputs="col-md-9" /> No</label></div></div></fieldset>';
		$this->assertEquals($expected, $result);
	}

}
