<?php
App::uses('Controller', 'Controller');
App::uses('View', 'View');
App::uses('HtmlHelper', 'View/Helper');
App::uses('FormExtHelper', 'EvForm.View/Helper');

class FormExtHelperTest extends CakeTestCase {

	public function setUp() {
		parent::setUp();
		$Controller = new Controller();
		$View = new View($Controller);
		$this->Form = new FormExtHelper($View);
	}

	public function testAddFieldSlug() {
		// Set HTTP Host for testing.
		$_SERVER['HTTP_HOST'] = 'example.com';

		// Test a standard slug alias field.
		$result = $this->Form->addField('Route.alias', ['type' => 'slug']);
		$expected = '<div class="input slug"><label for="RouteAlias">URL</label><span class="non-edit base-url">http://example.com/</span><span class="non-edit route"><span class="slug-display"></span><a href="#" class="edit-route">Edit URL</a></span><div class="input-edit-slug"><input name="data[Route][alias]" class="slug" value="" data-url-prefix="" type="slug" id="RouteAlias"/><a href="#" class="stop-editing">Stop Editing</a></div></div>';
		$this->assertEquals($expected, $result);

		return;
	}

	public function testAddFieldPrefixedSlug() {
		// Set HTTP Host for testing.
		$_SERVER['HTTP_HOST'] = 'example.com';

		// Test a prefixed slug alias field.
		$result = $this->Form->addField('Route.alias', ['type' => 'slug', 'url_prefix' => 'foo', 'value' => 'foo/bar']);
		$expected = '<div class="input slug"><label for="RouteAlias">URL</label><span class="non-edit base-url">http://example.com/</span><span class="non-edit route"><span class="slug-display">foo/bar</span><a href="#" class="edit-route">Edit URL</a></span><div class="input-edit-slug"><input name="data[Route][alias]" class="slug" value="foo/bar" data-url-prefix="foo" type="slug" id="RouteAlias"/><a href="#" class="stop-editing">Stop Editing</a></div></div>';
		$this->assertEquals($expected, $result);

		return;
	}

}
