# EvFormBuilder

## Installation

Install using Composer:-

	composer require evoluted/form-builder

Then add EvFormBuilder in the `'site'` array of the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvFormBuilder`.

If you want to run the migration use: `Console/cake Migrations.migration run all --plugin EvFormBuilder`.

The database tables and menu items are added through the migrations.

## Usage

Forms can be built through the CMS. A form is made up of question blocks, question blocks are made up of questions. Any question can belong to any question block but a question block can only have one of each question (no duplicates), this is the same between question blocks and forms. A question is made from a question type which are defined in the database. A question type denotes which input type the question will have as well as it's default options and if it can be required. If a question type has answers then a CMS user can add the answers they want a form user to choose from. They are added with comma separation.

## Question Types

The following question types are available by default once installed:

### Short Text

A basic text input. A single line of text can be entered and it can be required.

### Long Text

A basic text area input. Multiple lines of text can be entered and it can be required.

### Information

This question type provides a way for a CMS user to insert text between questions and wouldn't be interactable to the form user. It doesn't have a form input and can't be required.

### Checkbox

A basic checkbox input. Answers are provided by CMS users and it can be required.

### Yes/No

A radio input with the options yes or no. The radio options aren't avilable to be customised. It can be required.

### Single select

A basic dropdown input. Answers are provided by CMS users and it can be required.

## Reordering form sections

A CMS user can manipulate the structure of a form by reordering question blocks on a form or questions in a question block. To reorder questions in a question block, navigate to the question block in the CMS and click `Reorder Questions`. To reorder question blocks on a form, navigate to the form in the CMS and click `Reorder Question Blocks`. If a question exists in multiple question blocks then reordering it in one question block won't effect the order in other question blocks, the same goes for question blocks on forms.

## Associating forms with other models

Forms can be associated with any other model. To do so you just need to attach the behavior as follows:

```
public $actsAs = [
	'EvFormBuilder.Forms' => [
		'formInject' => true,
	],
];
```

By using the `formInject` behavior setting, the admin_edit form will be updated to have a "Form" input and any associated forms will be pulled out automatically. If you want to allow associations to have multiple forms then there is a config setting `associationsHaveMultipleForms` that can be enabled.


To get the form on any other page just contain the `Form` model.

## Displaying and submitting a form

The plugin contains a page that when directed to will allow a user to provide a response. The route to this page is:

```
[
	'plugin' => 'ev_form_builder',
	'controller' => 'forms',
	'action' => 'submit',
	{formId},
]
```

This page will deal with the displaying and submitting of the form. It uses 1 element for all question blocks and questions and each question type has it's own element, this is to hopefully allow overriding of certain parts of the form. If a form needs to be completely custom then the submit page in the plugin can be used as an example of how to set up a form.

A form can be added on any page by getting the form and contain the models `QuestionBlock`, `Question` and `QuestionType`. This would allow you to loop through each section and display as is required. The form can submitted to the submit page by setting the `url` property to the above route when using `$this->Form->create()` in a view. Make sure the form inputs are named correctly, as `FormResponse`, `QuestionBlockResponse` and `QuestionResponse` and that you are also submitting the relevant form, question block and question id data in each section.

### Associating form responses

When a user submits a form, a response is saved. A response can be associated with any model and multiple models. If you are associating a form with a model then it is most likely required that the response is as well. To set this up you need to add some arrays to the config:

```
'associations' => [
	'modelName' => [
		'className' => 'modelClass',
	],
	'Page' => [
		'className' => 'EvCore.Page',
	]
]
```

Having the model classes in the config allows the form response associations to be created if there isn't a session or if the model isn't loaded. If the submit page is being used (to display and or to submit) then the models and model ids also need to be added to the route like so:

```
[
	'plugin' => 'ev_form_builder',
	'controller' => 'forms',
	'action' => 'submit',
	{formId},
	'?' => [
		'modelName' => modelId,
		'page' => 3,
	]
]
```

The form response will be associated with each provided model as long as it exists in the config. If the submit page is not being used then associations can be added to the data and saved along with the form response.

## Images for forms

Image slots can be defined in the config file to be used on any of the models in EvFormBuilder. They are merged and loaded automatically on each model. Any image slots on the From/Question Block/Question are automatically contained on the submit page as part of the readForSubmit() method. The structure to defining image slots in the config is as follows:

```
'imageSlots' => [
	'QuestionBlock' => [
		'gallery' => [
			'slots' => -1,
			'fields' => [
				'alt',
				'caption',
			],
		],
	],
],
```
