<?php
	echo $this->Html->css(
		[
			'sortable',
		]
	);
?>

<div class='edit-form'>
	<div class='edit-form__header'>
		<h1 class='title'><?= $this->InflectorExt->camelToPluralize($displayName) ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			Reorder Questions for <?= $questionBlock['QuestionBlock']['name'] ?>
		</h2>

		<?= $this->element('toolbar') ?>
	</div>

	<div id="pane">
		<div id="controls">
			<a href="#" class="button save-reorderlisting">Save</a>
			&nbsp;
			<?php
				echo $this->Html->link(
					'Cancel',
					[
						'action' => 'edit',
						$questionBlock['QuestionBlock']['id']
					],
					[
						'class' => 'btn btn-danger',
					]
				);
			?>
		</div>

		<?php if (!empty($questionBlock['Question'])): ?>
			<ol class="cakesortable">
				<?php foreach ($questionBlock['Question'] as $question):?>
					<li id="list_<?= $question['QuestionBlocksQuestion']['id'] ?>">
						<div>
							<span class="disclose"><span></span></span>
							<span><?= h($question['name']) ?></span>
						</div>
					</li>
				<?php endforeach; ?>
			</ol>
		<?php endif; ?>

		<div id="controls">
			<a href="#" class="button save-reorderlisting">Save</a>
			&nbsp;
			<?php
				echo $this->Html->link(
					'Cancel',
					[
						'action' => 'edit',
						$questionBlock['QuestionBlock']['id']
					],
					[
						'class' => 'btn btn-danger',
					]
				);
			?>
		</div>
	</div>
</div>
<script>
	<?= 'document.orderkey = "' . $orderKey . '";' ?>
	<?= 'document.maxdepth = "' . $maxDepth . '";' ?>
</script>

<?php
	echo $this->Form->create(
		null,
		[
			'inputDefaults' => [
				'empty' => '',
			],
			'type' => 'file',
			'class' => '',
			'id' => 'cakeform',
		]
	);
?>

<div id="reorderFormContents"></div>

<?= $this->Form->end(); ?>

<?php
	echo $this->Html->script(
		[
			'jquery.mjs.nestedSortable',
			'sortable',
		],
		[
			'inline' => false,
		]
	);
?>
