<?php

App::uses('AppHelper', 'View/Helper');

class FormBuilderHelper extends AppHelper {

/**
 * Get the options for a question. If the question has default options then they are included first.
 *
 * @param array $question The question data.
 * @return array The array of options.
 */
	public function getOptionsFromQuestion($question) {
		$options = [];

		if (!empty($question['QuestionType']['default_options'])) {
			$question['answers'] = $question['QuestionType']['default_options'] . ',' . $question['answers'];
		}

		if (!empty($question['answers'])) {
			$answers = explode(',', $question['answers']);

			foreach ($answers as $answer) {
				$answer = trim($answer);

				if (!empty($answer)) {
					$options[$answer] = $answer;
				}
			}
		}

		return $options;
	}
}
