<?php
	echo $this->Html->css(
		[
			'sortable',
		]
	);
?>

<div class='edit-form'>
	<div class='edit-form__header'>
		<h1 class='title'><?= $this->InflectorExt->camelToPluralize($displayName) ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			Reorder Question Blocks for <?= $form['Form']['name'] ?>
		</h2>

		<?= $this->element('toolbar') ?>
	</div>

	<div id="pane">
		<div id="controls">
			<a href="#" class="button save-reorderlisting">Save</a>
			&nbsp;
			<?php
				echo $this->Html->link(
					'Cancel',
					[
						'action' => 'edit',
						$form['Form']['id']
					],
					[
						'class' => 'btn btn-danger',
					]
				);
			?>
		</div>

		<?php if (!empty($form['QuestionBlock'])): ?>
			<ol class="cakesortable">
				<?php foreach ($form['QuestionBlock'] as $questionBlock):?>
					<li id="list_<?= $questionBlock['FormsQuestionBlock']['id'] ?>">
						<div>
							<span class="disclose"><span></span></span>
							<span><?= h($questionBlock['name']) ?></span>
						</div>
					</li>
				<?php endforeach; ?>
			</ol>
		<?php endif; ?>

		<div id="controls">
			<a href="#" class="button save-reorderlisting">Save</a>
			&nbsp;
			<?php
				echo $this->Html->link(
					'Cancel',
					[
						'action' => 'edit',
						$form['Form']['id']
					],
					[
						'class' => 'btn btn-danger',
					]
				);
			?>
		</div>
	</div>
</div>
<script>
	<?= 'document.orderkey = "' . $orderKey . '";' ?>
	<?= 'document.maxdepth = "' . $maxDepth . '";' ?>
</script>

<?php
	echo $this->Form->create(
		null,
		[
			'inputDefaults' => [
				'empty' => '',
			],
			'type' => 'file',
			'class' => '',
			'id' => 'cakeform',
		]
	);
?>

<div id="reorderFormContents"></div>

<?= $this->Form->end(); ?>

<?php
	echo $this->Html->script(
		[
			'jquery.mjs.nestedSortable',
			'sortable',
		],
		[
			'inline' => false,
		]
	);
?>
