<?php

App::uses('EvFormBuilderAppModel', 'EvFormBuilder.Model');

class QuestionType extends EvFormBuilderAppModel {

	public $hasMany = [
		'Question' => [
			'className' => 'EvFormBuilder.Question',
		]
	];

/**
 * Get the list of question types for drop down menus.
 *
 * @param array $query Array of query params.
 * @return array List of question types.
 */
	public function getForDropDown($query = []) {
		$query = $this->_addQuestionTypeRestrictionParams($query);

		return parent::getForDropDown($query);
	}

/**
 * Get all the available question types.
 *
 * @param array $query Custom query parameters.
 * @return array The found question types.
 */
	public function getQuestionTypes($query = []) {
		$query = $this->_addQuestionTypeRestrictionParams($query);

		return $this->find(
			'all',
			$query
		);
	}

/**
 * Add the question type restrictions to a query parameter array.
 *
 * @param array $query The current query parameters.
 * @return array The query parameters with restrictions.
 */
	protected function _addQuestionTypeRestrictionParams($query = []) {
		if (!empty(Configure::read('EvFormBuilder.restrictQuestionTypes'))) {
			$query['conditions'][$this->alias . '.system_name'] = Configure::read('EvFormBuilder.restrictQuestionTypes');
		}

		return $query;
	}
}
