<?php

App::uses('EvFormBuilderAppModel', 'EvFormBuilder.Model');

class QuestionResponse extends EvFormBuilderAppModel {

	public $belongsTo = [
		'QuestionBlockResponse' => [
			'className' => 'EvFormBuilder.QuestionBlockResponse',
		],
		'Question' => [
			'className' => 'EvFormBuilder.Question',
		]
	];

/**
 * Called during validation operations, before validation. Please note that custom
 * validation rules can be defined in $validate.
 *
 * @param array $options Options passed from Model::save().
 * @return bool True if validate operation should continue, false to abort
 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#beforevalidate
 * @see Model::save()
 */
	public function beforeValidate($options = []) {
		if (empty($this->data[$this->alias]['question_id'])) {
			$this->validationErrors[] = 'A question id needs to be provided to save a response';
			return false;
		}

		$questionId = $this->data[$this->alias]['question_id'];
		$question = $this->Question->find(
			'first',
			[
				'conditions' => [
					$this->Question->alias . '.id' => $questionId,
				],
				'contain' => [
					'QuestionType'
				],
			]
		);

		if (!empty($question)) {
			$this->_addQuestionResponseValidation($question);
		}
	}

/**
 * A response to a question is about to be saved and might need validation added. Check the provided
 * question data and add validation rules as necessary. Called from beforeValidate.
 *
 * @param array $question The question to check for validation rules.
 * @return void.
 */
	protected function _addQuestionResponseValidation($question) {
		if (!empty($question['Question']['is_required'])) {
			$requiredRule = ['notBlank'];
			if (!empty($question['QuestionType']['is_multiple'])) {
				$requiredRule = ['multiple', ['min' => 1]];
			}

			$this->validate['response']['isRequired'] = [
				'rule' => $requiredRule,
				'message' => 'The question, ' . $question['Question']['name'] . ', must be answered',
				'required' => true,
			];
		} elseif (isset($this->validate['response']['isRequired'])) {
			unset($this->validate['response']['isRequired']);
		}
	}

/**
 * Called before each save operation, after validation. Return a non-true result
 * to halt the save.
 *
 * json encode user responses if the response is in an array.
 *
 * @param array $options Options passed from Model::save().
 * @return bool True if the operation should continue, false if it should abort
 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#beforesave
 * @see Model::save()
 */
	public function beforeSave($options = []) {
		if (!empty($this->data[$this->alias]['response'])) {
			$response = $this->data[$this->alias]['response'];

			if (is_array($response)) {
				$response = json_encode($response);
				$this->data[$this->alias]['response'] = $response;
			}
		}
	}
}
