<?php

App::uses('EvFormBuilderAppModel', 'EvFormBuilder.Model');

class QuestionBlock extends EvFormBuilderAppModel {

	public $hasMany = [
		'QuestionBlockResponse' => [
			'className' => 'EvFormBuilder.QuestionBlockResponse',
		],
	];

	public $hasAndBelongsToMany = [
		'Form' => [
			'className' => 'EvFormBuilder.Form',
			'foreignKey' => 'question_block_id',
			'associationForeignKey' => 'form_id',
			'with' => 'EvFormBuilder.FormsQuestionBlock',
			'order' => 'FormsQuestionBlock.sequence',
			'unique' => 'keepExisting',
		],
		'Question' => [
			'className' => 'EvFormBuilder.Question',
			'foreignKey' => 'question_block_id',
			'associationForeignKey' => 'question_id',
			'with' => 'EvFormBuilder.QuestionBlocksQuestion',
			'order' => 'QuestionBlocksQuestion.sequence',
			'unique' => 'keepExisting',
		],
	];

	public $validate = [
		'name' => [
			'required' => [
				'rule' => ['notBlank'],
				'message' => 'The question block name must not be blank.',
			]
		]
	];

/**
 * Get the list of question blocks for a drop down menu.
 *
 * @param array $query Array of query params.
 * @return array List of question blocks.
 */
	public function getForDropDown($query = array()) {
		$virtualFields = $this->virtualFields;

		$query = $this->addDropDownQueryParams($query);

		$dropdownResults = parent::getForDropDown($query);

		$this->virtualFields = $virtualFields;

		return $dropdownResults;
	}

/**
 * Query used to retrieve a record ready for edit.
 *
 * @param int   $id     ID of row to edit.
 * @param array $params The db query array.
 * @return array The found item.
 */
	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'Question';

		return parent::readForEdit($id, $params);
	}
}
