<?php

App::uses('AppModel', 'Model');

class EvFormBuilderAppModel extends AppModel {

	public $plugin = 'EvFormBuilder';

	public $tablePrefix = "ev_form_builder_";

/**
 * Constructor. Binds the model's database table to the object.
 *
 * @param bool|int|string|array $id Set this ID for this model on startup,
 * can also be an array of options, see above.
 * @param string $table Name of database table to use.
 * @param string $ds DataSource connection name.
 */
	public function __construct($id = false, $table = null, $ds = null) {
		if (!empty($id['alias']) && !empty(Configure::read('EvFormBuilder.imageSlots.' . $id['alias']))) {
			if (is_array($this->imageSlots)) {
				$this->imageSlots = array_merge(
					$this->imageSlots,
					Configure::read('EvFormBuilder.imageSlots.' . $id['alias'])
				);
			} else {
				$this->imageSlots = Configure::read('EvFormBuilder.imageSlots.' . $id['alias']);
			}
		}

		parent::__construct($id, $table, $ds);
	}

/**
 * Add parameters and virtual fields to a dropdown query. Display the correct name. Adds virtual fields to model.
 *
 * @param array $query The current dropdown query.
 * @return array The modified query.
 */
	public function addDropDownQueryParams($query) {
		$this->virtualFields['dropdown_name'] = 'IF(' . $this->alias . '.internal_name IS NOT NULL AND ' . $this->alias . '.internal_name != "", ' . $this->alias . '.internal_name, ' . $this->alias . '.' . $this->displayField . ')';

		$query['fields'] = [
			$this->alias . '.id',
			$this->alias . '.dropdown_name',
		];

		return $query;
	}
}
