<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class FormResponseAuditLogPresenter extends AuditLogPresenter {

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'user_id':
				return 'User';
			case 'form_id':
				return 'Form';
			default:
				return parent::presentPropertyName($audit, $auditDelta);
		}
	}

/**
 * Present a audit delta value. If the value is null return an empty string. If the model is present
 * on the audit then an attempt to use a plugin presenter will occur, otherwise the value is returned
 * withou any modification.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @param string $value 	The default value
 * @return string The value to present.
 */
	public function presentValue($audit, $auditDelta, $value) {
		switch ($auditDelta['property_name']) {
			case 'user_id':
				$value = $this->_lookupValue('EvCore.User', $value);
				break;
			case 'form_id':
				$value = $this->_lookupValue('EvFormBuilder.Form', $value);
				break;
		}

		return parent::presentValue($audit, $auditDelta, $value);
	}

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'id':
				return false;
			default:
				return parent::shouldPresentProperty($audit, $auditDelta);
		}
	}
}
