<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class FormResponseAssociationAuditLogPresenter extends AuditLogPresenter {

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'form_response_id':
				return 'Form';
			case 'model':
				return 'Response to';
			case 'model_id':
				return 'Responded for';
			default:
				return parent::presentPropertyName($audit, $auditDelta);
		}
	}

/**
 * Present a audit delta value. If the value is null return an empty string. If the model is present
 * on the audit then an attempt to use a plugin presenter will occur, otherwise the value is returned
 * withou any modification.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @param string $value 	The default value
 * @return string The value to present.
 */
	public function presentValue($audit, $auditDelta, $value) {
		switch ($auditDelta['property_name']) {
			case 'form_response_id':
				$FormResponse = EvClassRegistry::init('EvFormBuilder.FormResponse');
				$formResponse = $FormResponse->find(
					'first',
					[
						'conditions' => [
							'FormResponse.id' => $value,
						],
						'contain' => [
							'Form',
							'User',
						]
					]
				);

				if (!empty($formResponse['Form']) && !empty($formResponse['User'])) {
					$value = $formResponse['User']['email'] . ' response of ';
					$value .= $formResponse['Form']['name'];
				}
				break;
			case 'model':
				list($plugin, $modelAlias) = pluginSplit($value);

				if (!empty($modelAlias)) {
					$value = $modelAlias;
				}
				break;
			case 'model_id':
				if (!empty($audit['json_object'])) {
					$auditData = json_decode($audit['json_object'], true);

					if (!empty($auditData['FormResponseAssociation']['model'])) {
						$ModelIdModel = EvClassRegistry::init($auditData['FormResponseAssociation']['model']);
						$modelIdData = $ModelIdModel->find(
							'first',
							[
								'conditions' => [
									$ModelIdModel->alias . '.' . $ModelIdModel->primaryKey => $value,
								],
							]
						);

						if (!empty($modelIdData[$ModelIdModel->alias][$ModelIdModel->displayField])) {
							$value = $modelIdData[$ModelIdModel->alias][$ModelIdModel->displayField];
						}
					}
				}
				break;
		}

		return parent::presentValue($audit, $auditDelta, $value);
	}

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'id':
				return false;
			default:
				return parent::shouldPresentProperty($audit, $auditDelta);
		}
	}
}
