<?php

App::uses('EvFormBuilderAppController', 'EvFormBuilder.Controller');

class QuestionsController extends EvFormBuilderAppController {

/**
 * Pagination settings for admin_index.
 *
 * @return array Pagination settings.
 */
	protected function _adminIndexPaginate() {
		$Model = $this->{$this->modelClass};

		$paginate = parent::_adminIndexPaginate();

		$paginate['contain'][] = 'QuestionType';

		return $paginate;
	}

/**
 * Defines the fields displayed in a filter form. Defaults to id, display name, is_active, created and modified fields.
 *
 * @return array The fields to use in the admin filter.
 */
	protected function _adminFilterFields() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$fields = parent::_adminFilterFields();

		$preActiveFilterFields = [
			$modelAlias . '.internal_name' => [
				'label' => 'Internal Name',
				'type' => 'string',
				'compare' => [
					$modelAlias . '.internal_name LIKE' => '%%%s%%',
				],
			],
			$modelAlias . '.question_type_id' => [
				'label' => 'Question Type',
				'type' => 'integer',
				'compare' => [
					$modelAlias . '.question_type_id' => '%s',
				],
			],
			$modelAlias . '.is_required' => [
				'label' => 'Required',
				'type' => 'boolean',
				'compare' => [
					$modelAlias . '.is_required' => '%s',
				],
			],
		];

		$fields = ArrayUtil::addBefore($fields, $modelAlias . '.is_active', $preActiveFilterFields);

		return $fields;
	}

/**
 * Used to populate form drop down selects
 *
 * @return void.
 */
	protected function _adminPopulateLookups() {
		$Model = $this->{$this->modelClass};

		$this->set('questionTypes', $Model->QuestionType->getForDropDown());
	}

/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 *
 * @return array admin_index columns.
 */
	protected function _adminIndexColumns() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumns();

		$preActiveColumns = [
			$modelAlias . '.internal_name' => [
				'type' => 'string',
				'label' => 'Internal Name',
			],
			'QuestionType.name' => [
				'type' => 'string',
				'label' => 'Question Type',
			],
		];

		$columns = ArrayUtil::addBefore($columns, $modelAlias . '.is_active', $preActiveColumns);

		return $columns;
	}

/**
 * Defines the fields displayed in an admin_form for this model. Defaults to all fields in the db table.
 *
 * @return array The fields for the question admin form.
 */
	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$fields = parent::_adminFormFields();

		if (empty($this->request->data[$modelAlias]['id'])) {
			//We are creating so only want to create name and question type.
			$newQuestionFields = [];
			if (isset($fields[$modelAlias . '.id'])) {
				$newQuestionFields[$modelAlias . '.id'] = $fields[$modelAlias . '.id'];
			}

			if (isset($fields[$modelAlias . '.question_type_id'])) {
				$newQuestionFields[$modelAlias . '.question_type_id'] = $fields[$modelAlias . '.question_type_id'];
			}

			if (isset($fields[$modelAlias . '.name'])) {
				$newQuestionFields[$modelAlias . '.name'] = $fields[$modelAlias . '.name'];
			}

			$fields = $newQuestionFields;
		} else {
			//Disable the question type so it can't be changed and restrict question fields.
			$fields = $this->_restrictQuestionAdminFormFields($Model, $this->request->data, $fields);
		}

		//General form field modifications
		if (isset($fields[$modelAlias . '.name'])) {
			$fields[$modelAlias . '.name']['label']['text'] = 'Question';
		}

		if (isset($fields[$modelAlias . '.body'])) {
			$fields[$modelAlias . '.body']['displayInfo'] = 'This text will be shown next to the question to provide more detail about the question or example answers.';
		}

		if (isset($fields[$modelAlias . '.help'])) {
			$fields[$modelAlias . '.help']['type'] = 'text_plain';
			$fields[$modelAlias . '.help']['displayInfo'] = 'This text will be shown next to the question to provide information on how to answer the question.';
		}

		if (isset($fields[$modelAlias . '.answers'])) {
			$fields[$modelAlias . '.answers']['type'] = 'text_plain';
			$fields[$modelAlias . '.answers']['displayInfo'] = 'Please separate each answer with a comma.';
		}

		return $fields;
	}

/**
 * Once the question has been created the question type can't change so it will be disabled.
 * The question fields will be limited based on the question type.
 *
 * @param Model $Model  The controller model.
 * @param array $data   The request data.
 * @param array $fields The current admin form fields.
 * @return array Restricted admin form fields.
 */
	protected function _restrictQuestionAdminFormFields($Model, $data, $fields) {
		if (!empty($data[$Model->QuestionType->alias])) {
			$questionType = $data[$Model->QuestionType->alias];

			if (empty($questionType['can_have_answers']) && isset($fields[$Model->alias . '.answers'])) {
				unset($fields[$Model->alias . '.answers']);
			}

			if (empty($questionType['can_be_required']) && isset($fields[$Model->alias . '.is_required'])) {
				unset($fields[$Model->alias . '.is_required']);
			}

			//If the question type is missing then an input field will not be used and the help isn't needed.
			if (empty($questionType['input_type']) && isset($fields[$Model->alias . '.help'])) {
				unset($fields[$Model->alias . '.help']);
			}

			$fields[$Model->alias . '.question_type_id']['type'] = 'hidden';
			$fields = ArrayUtil::addAfter($fields, $Model->alias . '.question_type_id', [
				$Model->alias . '.question_type' => [
					'type' => 'string',
					'value' => $questionType['name'],
					'disabled' => 'disabled'
				]
			]);
		}

		return $fields;
	}
}
